Name: libzio
Version: 1.04
Release: alt1

Summary: A library for accessing compressed text files
License: GPLv2+
Group: System/Libraries
Url: http://libzio.sourceforge.net/

# http://downloads.sourceforge.net/libzio/libzio-%version.tar.bz2
Source: libzio-%version.tar
Patch: %name-%version-%release.patch

BuildPreReq: zlib-devel bzlib-devel liblzma-devel xz

%package devel
Summary: Development files for the libzio library
Group: Development/C
Requires: %name = %version-%release

%description
Libzio provides a wrapper function for reading or writing gzip, bzip2
and lzma-compressed files with FILE streams.

%description devel
Libzio provides a wrapper function for reading or writing gzip, bzip2
and lzma-compressed files with FILE streams.

This package contains library and header files needed for
building libzio-aware applications.

%prep
%setup
%patch -p1

%build
%def_enable Werror
%make_build libdir=/%_lib noweak tests testt testw

%install
%make_install install-shared install-data \
	DESTDIR=%buildroot libdir=/%_lib mandir=%_mandir

# Relocate development library from /%_lib/ to %_libdir/.
mkdir -p %buildroot%_libdir
for f in %buildroot/%_lib/*.so; do
	t=$(readlink "$f")
	ln -s ../../%_lib/"$t" "%buildroot%_libdir/${f##*/}"
	rm "$f"
done

%set_verify_elf_method strict
%define _unpackaged_files_terminate_build 1

%check
for s in gz bz2 lzma xz; do
	ln -s sample sample.$s
done
for f in *; do
	[ -f "$f" -a ! -L "$f" ] || continue
	for comp in gzip bzip2 lzma xz; do
		$comp -c <"$f" >sample
		for s in '' .gz .bz2 .lzma .xz; do
			LD_LIBRARY_PATH=%buildroot/%_lib ./testt sample$s |
				cmp "$f" -
			cat sample$s |
				LD_LIBRARY_PATH=%buildroot/%_lib ./tests ${comp:0:1} |
				cmp "$f" -
		done
	done
done
rm sample*
for f in *; do
	[ -f "$f" -a ! -L "$f" ] || continue
	rm -f sample*
	LD_LIBRARY_PATH=%buildroot/%_lib ./testw sample <"$f"
	cmp "$f" sample
	LD_LIBRARY_PATH=%buildroot/%_lib ./testw sample.gz <"$f"
	gzip -dc <sample.gz |cmp "$f" -
	LD_LIBRARY_PATH=%buildroot/%_lib ./testw sample.bz2 <"$f"
	bzip2 -dc <sample.bz2 |cmp "$f" -
	LD_LIBRARY_PATH=%buildroot/%_lib ./testw sample.xz <"$f"
	xz -dc <sample.xz |cmp "$f" -
	LD_LIBRARY_PATH=%buildroot/%_lib ./testw sample.lzma <"$f"
	lzma -dc <sample.lzma |cmp "$f" -
done

%files
%doc README
/%_lib/*.so.*

%files devel
%_libdir/*.so
%_includedir/*
%_man3dir/*

%changelog
