%define lIF_ver_gt() %if "%(rpmvercmp '%1' '%2')" > "0"
%define lIF_ver_gteq() %if "%(rpmvercmp '%1' '%2')" >= "0"
%define lIF_ver_lt() %if "%(rpmvercmp '%2' '%1')" > "0"
%define lIF_ver_lteq() %if "%(rpmvercmp '%2' '%1')" >= "0"

# define names and paths of QT/KDE packages
%define glibc_core_ver %{get_version glibc-core}

%define _optlevel s
%define socks 0
%define cvs 0
%define no_some_docs 1

#UI plugins
%define with_qt4 1
%define with_kde4 1
# removed some time ago (near version 1.4)
%define with_gtk 0
# removed in 1.8.0
%define with_console 0

#protocol plugins
%define with_msn 1
%define with_jabber 1
%define with_icq 1

#other plugins
%define with_email 1
%define with_auto_reply 1
%define with_rms 1
%define with_osd 1
%define with_aosd 1
%define with_gpg 1

# name-version-release
%define rname licq
%define ver 1.8.2
%define rlz alt1

%define common_summary Multi-protocol IM-client (icq,jabber,msn) written on C++

%define common_description Licq was written as ICQ clone but it is multi-protocol IM now.\
Licq supports different interfaces, protocols and functions via plugins.\
\
This package contains the base files for Licq (the Licq daemon) and the QT\
plugin, which is written using the Qt widget set. Currently this UI plugin\
is only available (since v1.8).\
\
This starts the QT plugin by default, so to run other plugins, you will have\
to issue the command "licq -p <plugin>" once. To get back the Qt plugin, you\
will have to run once "licq -p qt-gui". Alternatively you may be able to do\
it in a plugin dialog box if your plugin supports this feature.\
\
This version of Licq has SSL support for those plugins that support it.

Name: %rname
Version: %ver
Release: %rlz.1.1

BuildRequires(pre): kde4libs-devel
BuildRequires(pre): graphviz

BuildRequires: freetype2-devel gcc-c++ chrpath
BuildRequires: libart_lgpl-devel libexpat-devel libjpeg-devel
BuildRequires: liblcms-devel libmng-devel kde-common-devel
BuildRequires: libncurses-devel libssl-devel libstdc++-devel libtinfo-devel
BuildRequires: rpm-utils boost-devel doxygen libgloox-devel
BuildRequires: libpixman-devel libharfbuzz-devel
%if %with_console
BuildRequires: libcdk-devel
%endif
%if %with_qt4
BuildRequires: libqt4-devel
%endif
%if %with_kde4
BuildRequires: kde4libs-devel
%endif
%if %socks
BuildRequires: libdante-devel
%endif
%if %with_gtk
BuildRequires: libgtk+2-devel
%endif
%if %with_osd
BuildRequires: libxosd-devel cvs
%endif
%if %with_aosd
BuildRequires: libaosd-devel glib2-devel
%endif
%if %with_gpg
BuildRequires: libgpgme-devel libgpg-error-devel
%endif

########################
Source: %name.tar
%if %with_auto_reply
#Source1: ftp://ftp.licq.org/pub/licq/plugins/%name-auto-reply-%%cvsdate.tar
%endif
%if %with_gtk
Source5: ftp://ftp.licq.org/pub/licq/plugins/icqnd-0.1.9.6.tar
%endif

########################

Source9: licq-tracepath.utility
Source10: licq-viewurl.sh
Source21: %name.16.xpm.bz2
Source22: %name.32.xpm.bz2
Source23: %name.48.xpm.bz2

Patch2: licq-1.5.0-alt-xvt.patch
Patch3: licq-1.7.0-alt-qt4-def-encoding.patch
#
Patch17: licq_osd_plugin-1.3.2.1-defaults.patch
#
Patch22: licq-1.3.6-alt-qt4-yes-stl.patch

Patch200: licq-1.2.7-remove-pidfile.patch

#Errata
#Patch500:

#package licq
Group: Networking/Instant messaging
Summary: %common_summary
License: GPL
Url: http://www.licq.org/
Requires: %name-jabber = %version-%release
%if %with_osd
Requires: %name-osd = %version-%release
%endif
%if %with_kde4
Requires: %name-kde4 = %version-%release
%else
Requires: %name-ui
%endif


%package maxi
Group: Networking/Instant messaging
Summary: %common_summary
BuildArch: noarch
%if %with_msn
Requires: %name-msn = %version-%release
%endif
%if %with_jabber
Requires: %name-jabber = %version-%release
%endif
%if %with_email
Requires: %name-email = %version-%release
%endif
%if %with_auto_reply
Requires: %name-autoreply = %version-%release
%endif
%if %with_rms
Requires: %name-rms = %version-%release
%endif
%if %with_osd
Requires: %name-osd = %version-%release
%endif
%if %with_aosd
Requires: %name-aosd = %version-%release
%endif
%if %with_qt4
Requires: %name-qt4 = %version-%release
%else
Requires: %name-ui
%endif
%if %with_kde4
Requires: %name-kde4 = %version-%release
%else
Requires: %name-ui
%endif
%if %with_gtk
Requires: %name-gtk = %version-%release
%else
Requires: %name-ui
%endif
%if %with_console
Requires: %name-console = %version-%release
%else
Requires: %name-ui
%endif

%package mini
Group: Networking/Instant messaging
Summary: %common_summary
BuildArch: noarch
%if %with_qt4
Requires: %name-qt4 = %version-%release
%else
Requires: %name-ui
%endif

%package common
Summary: Common binaries and data files  for Licq
Group: Networking/Instant messaging
Obsoletes: %name-ssl < %version-release
Obsoletes: %name-data < %version-release
Obsoletes: %name-update-hosts < %version-release
Provides: %name-base = %version-release
Obsoletes: %name-base < %version-release
Requires: sound_handler

%package kde4
Group: Networking/Instant messaging
Summary: The default Licq's plugin for KDE4
Provides: %name-plugin %name-ui
Provides: licq-kde = %version-%release
Obsoletes: licq-kde < %version-%release
Requires: %name-common = %version-%release
Requires: kde4libs >= %{get_version kde4libs}
Requires: %name-qt4

%package qt4
Summary: Qt4 based GUI plugin  for Licq
Group: Networking/Instant messaging
Provides: %name-plugin %name-ui
Provides: licq-qt = %version-%release
Obsoletes: licq-qt < %version-%release
Requires: %name-common = %version-%release
Requires: libqt4-core >= %{get_version libqt4-core}

%package gtk
Summary: GTK+ based GUI plugin for Licq
Group: Networking/Instant messaging
Provides: %name-plugin %name-ui
Requires: %name-common = %version-%release

%package console
Summary: Console based plugin for Licq that uses ncurses
Group: Networking/Instant messaging
Provides: %name-plugin %name-ui
Requires: %name-common = %version-%release

%package email
Summary: Email forwarder plugin for Licq
Group: Networking/Instant messaging
Provides: %name-plugin, %name-forwarder = %version-%release
Obsoletes: %name-forwarder < %version-%release
Requires: %name-common = %version-%release

%package autoreply
Summary: Autoreply plugin for Licq
Group: Networking/Instant messaging
Provides: %name-plugin
Requires: %name-common = %version-%release

%package rms
Summary: Remote management service plugin for Licq
Group: Networking/Instant messaging
Provides: %name-plugin
Requires: %name-common = %version-%release

%package osd
Summary: OSD (On Screen Dysplay) plugin for Licq
Group: Networking/Instant messaging
Provides: %name-plugin
Requires: %name-common = %version-%release

%package aosd
Summary: OSD (On Screen Dysplay) plugin for Licq
Group: Networking/Instant messaging
Provides: %name-plugin
Requires: %name-common = %version-%release

%package icq
Summary: ICQ protocol plugin for Licq
Group: Networking/Instant messaging
Provides: %name-plugin
Requires: %name-common = %version-%release

%package msn
Summary: MSN protocol plugin for Licq
Group: Networking/Instant messaging
Provides: %name-plugin
Requires: %name-common = %version-%release

%package jabber
Summary: XMPP(Jabber) protocol plugin for Licq
Group: Networking/Instant messaging
Provides: %name-plugin
Requires: %name-common = %version-%release

%package devel
Summary: Development files for Licq
Group: Development/C
Requires: %name-common = %version-%release

%description
%common_description

%description maxi
%common_description

%description mini
%common_description

%description kde4
This is the KDE4 based GUI plugin for Licq.
Install this if you want a KDE4-based GUI for Licq.

%description common
Common binaries and data files  for Licq

%description devel
This is the header files that you will need in order to compile Licq plugins.

%description rms
RMS stands for the Remote Management Service. It is a plugin for Licq which
enables you to "telnet" to your Licq box to perform various tasks. Security is
implemented through basic username and password authentication.

%description qt4
This is the Qt4 based GUI for Licq.
Install this and if you want a Qt4-based GUI for Licq.

%description gtk
This is the GTK+ based GUI plugin for Licq.
Install this if you want a GTK+ based GUI for Licq.

%description console
This is a console based plugin for Licq that uses ncurses that came in the
standard Licq source package. It is extremely usable and functional, but it
does not currently have support for gpm.

Install this if you want to run Licq on the console.

%description email
This plugin for Licq lets you forward messages to your email account. This is a
plugin that came with the standard Licq source package. It can be run
concurrently with a UI plugin.

Install this if you want to add this function to Licq.

%description autoreply
This plugin for Licq enables Licq to auto reply to messages. This is a plugin
standard Licq source package. It can be run concurrently with a UI plugin.

Install this if you want to add this function to Licq.

%description osd
This is a small plugin, which uses libxosd2 to
display new arriving messages as OSD (On Screen Display)
text on your desktop.

Install this if you want to add this function to Licq.

%description aosd
This is a small plugin, which uses libaosd to
display new arriving messages as OSD (On Screen Display)
text on your desktop.

Install this if you want to add this function to Licq.

%description icq
ICQ Protocol Plugin.

Install this if you want to add this function to Licq.

%description msn
MSN Protocol Plugin.

Install this if you want to add this function to Licq.

%description jabber
Jabber(XMPP) Protocol Plugin.

Install this if you want to add this function to Licq.

### PREP ##########################################
%prep
%ifdef autoreconf
%undefine autoreconf
%define autoreconf aclocal --force; autoconf; automake
%endif

%setup -q -n %name

#Errata
#patch500 -p2

pushd plugins
%if %with_gtk
    tar xfj %SOURCE5
    mv icqnd-* icqnd
%endif
popd

install -m 644 %SOURCE9 share/utilities/tracepath.utility

%patch2 -p1

%if %with_osd
pushd plugins/osd*
%patch17 -p1
popd
%endif

# with_qt4 || with_kde4
pushd plugins/qt4-gui*
%patch3 -p0
%patch22 -p1
popd

%if %with_aosd
%else
    rm -rf plugins/aosd
%endif
%if %with_console
%else
    rm -rf plugins/console
%endif

cd plugins/qt4-gui*

%if %with_qt4
cd ../qt4-gui*
sed -i "s|\s*Name\s*=.*|Name=Licq [Qt4]|" share/misc/licq.desktop
sed -i "s|\s*Exec\s*=.*|Exec=licq -p qt4-gui|" share/misc/licq.desktop
sed -i 's|/applications)|/applications RENAME licq-qt4.desktop)|' share/misc/CMakeLists.txt
#sed -i 's|set(USE_KDE.*|set(USE_KDE FALSE)|' CMakeLists.txt
#sed -i 's|option(WITH_KDE.*|set(WITH_KDE FALSE)|' CMakeLists.txt
find -type f -name CMakeLists.txt | \
while read f; do sed -i 's|WITH_KDE|QT_WITH_KDE|' $f; done
%endif

%if %with_kde4
cd ..; cp -r qt4-gui* kde4-gui
cd kde4-gui; rm -rf qt4-gui*
sed -i "s|\s*Name\s*=.*|Name=Licq [KDE4]|" share/misc/licq.desktop
sed -i "s|\s*Exec\s*=.*|Exec=licq -p kde4-gui|" share/misc/licq.desktop
sed -i 's|Qt4-GUI|KDE4-GUI|' CMakeLists.txt
sed -i 's|add_subdirectory(doc)||' CMakeLists.txt
#sed -i 's|set(USE_KDE.*|set(USE_KDE TRUE)|' CMakeLists.txt
#sed -i 's|option(WITH_KDE.*|set(WITH_KDE TRUE)|' CMakeLists.txt
find -type f -name CMakeLists.txt | \
while read f; do sed -i 's|QT_WITH_KDE|WITH_KDE|' $f; done
%endif

cd ../..

### BUILD ##########################################
%build
#add_optflags -D_FILE_OFFSET_BITS=64
#export CFLAGS="%optflags" CXXFLAGS="%optflags" CPPFLAGS="%optflags"

%K4cmake \
    -DINCLUDE_INSTALL_DIR=%_includedir \
    -DWITH_KDE:BOOL=ON \
    -DQT_WITH_KDE:BOOL=OFF \
    -DBUILD_TESTS:BOOL=OFF \
    -DBUILD_PLUGINS:BOOL=ON
%K4make

### INSTALL ##########################################
%install
%K4install

rm -rf %buildroot/%_datadir/licq/translations

#mkdir -p %buildroot/%_bindir
ln -fs licq %buildroot/%_bindir/licq-ssl
install -m755 %SOURCE10 %buildroot/%_bindir/licq-viewurl.sh

mkdir -p %buildroot/%_miconsdir
mkdir -p %buildroot/%_niconsdir
mkdir -p %buildroot/%_liconsdir
bzip2 -dc %SOURCE21 > %buildroot/%_miconsdir/licq.xpm
bzip2 -dc %SOURCE22 > %buildroot/%_niconsdir/licq.xpm
bzip2 -dc %SOURCE23 > %buildroot/%_liconsdir/licq.xpm

# menu stuff GTK
%if %with_gtk
mkdir -p %buildroot/%_menudir
cat > %buildroot/%_menudir/%name-gtk <<EOF
    ?package(licq-gtk):\
    command="licq -p gtk-gui"\
    icon="licq.xpm"\
    title="Licq [GTK]"\
    longtitle="ICQ client"\
    needs="x11"\
    section="Networking/Instant messaging"
EOF
%endif

# menu stuff console
%if %with_console
mkdir -p %buildroot/%_menudir
cat > %buildroot/%_menudir/%name-console <<EOF
    ?package(licq-console):\
    command="licq -p console"\
    icon="licq.xpm"\
    title="Licq [console]"\
    longtitle="Text based ICQ client"\
    needs="text"\
    section="Networking/Instant messaging"
EOF
%endif


%if %with_gtk
pushd plugins/icqnd
%make install DESTDIR=%buildroot libdir=%_libdir/%name
ln -s licq_icqnd.so %buildroot/%_libdir/licq/licq_gtk-gui.so
popd
%endif

# remove rpath from plugins
#find %buildroot -type f -name \*.so | while read f; do chrpath -d $f; done

%find_lang %name
%find_lang licq_osd_plugin


### FILES ##########################################
#
%files
%files maxi
%files mini

%if %with_kde4
## kde4 plugin
%files kde4
%_libdir/licq/licq*kde4-gui*
%_desktopdir/kde4/licq.desktop
%endif

%if %with_qt4
## licq qt4 plugin
%files qt4
%_libdir/licq/licq*qt4-gui*
%_datadir/licq/qt4-gui/
%_desktopdir/licq-qt4.desktop
%endif

## licq base
%files common -f %name.lang
%_bindir/licq
%_bindir/licq-ssl
%dir %_libdir/licq/
%dir %_datadir/licq/
%_datadir/licq/utilities/
%_datadir/licq/sounds/
%_miconsdir/licq.xpm
%_niconsdir/licq.xpm
%_liconsdir/licq.xpm
%attr(0755,root,root) %_bindir/licq-viewurl.sh
%doc doc/ upgrade/ README*
%if !%no_some_docs
%doc ChangeLog
%endif
%if %with_gpg
%doc licq_gpg.conf
%endif

%if %with_gtk
## gtk plugin
%files gtk
%_menudir/licq-gtk
%_libdir/licq/licq*icqnd*
%_libdir/licq/licq*gtk-gui*
%_datadir/licq/icqnd
%endif

%if %with_osd
## osd plugin
%files osd -f licq_osd_plugin.lang
%_libdir/licq/licq_osd.*
%doc plugins/osd*/%{name}_osd.conf
%doc plugins/osd*/{AUTHORS,TODO,README}
%endif

%if %with_osd
## aosd plugin
%files aosd
%_libdir/licq/licq_aosd.*
#%doc plugins/aosd*/%{name}_osd.conf
%doc plugins/aosd*/README
%endif

%if %with_icq
## icq plugin
%files icq
%_libdir/licq/protocol_icq.*
%endif

%if %with_msn
## msn plugin
%files msn
%_libdir/licq/protocol_msn.*
%doc plugins/msn*/owner.MSN_
%doc plugins/msn*/README
%endif

%if %with_jabber
## jabber plugin
%files jabber
%_libdir/licq/protocol_jabber.*
%doc plugins/jabber*/README
%endif

## devel
%files devel
%_includedir/licq
%_datadir/licq/cmake

%if %with_console
## console plugin
%files console
%_menudir/licq-console
%_libdir/licq/licq_console.*
%doc plugins/console*/README
%doc plugins/console*/%{name}_console.conf
%endif


%if %with_email
## email plugin
%files email
%_libdir/licq/licq_forwarder.*
%doc plugins/forwarder*/README
%doc plugins/forwarder*/%{name}_forwarder.conf
%endif

%if %with_auto_reply
## auto reply plugin
%files autoreply
%_libdir/licq/licq_autoreply.*
%doc plugins/auto-reply*/README
%doc plugins/auto-reply*/%{name}_autoreply.conf
%endif

%if %with_rms
## remote management svcx
%files rms
%_libdir/licq/licq_rms.*
%doc plugins/rms*/README
%doc plugins/rms*/%{name}_rms.conf
%endif

########################################################
%changelog
