%def_enable libnotify

Name: liferea
Version: 1.10.16
Release: alt1
Summary: A RSS News Reader for GNOME
License: GPLv2
Group: Networking/News
Url: http://lzone.de/liferea

Obsoletes: %name-gtkhtml < %version-%release %name-xulrunner < %version-%release
Provides: %name-backend = %version-%release %name-gtkhtml = %version-%release %name-xulrunner = %version-%release

Source: %name-%version.tar
Patch: %name-%version-%release.patch

BuildRequires(pre): gobject-introspection-devel
BuildRequires: gcc-c++ intltool
BuildRequires: pkgconfig(gtk+-3.0) >= 3.4.0
BuildRequires: pkgconfig(glib-2.0) >= 2.28.0 pkgconfig(gio-2.0) >= 2.26.0 pkgconfig(gmodule-2.0) >= 2.0.0 pkgconfig(gthread-2.0)
BuildRequires: pkgconfig(pango) >= 1.4.0
BuildRequires: pkgconfig(libxml-2.0) >= 2.6.27 pkgconfig(libxslt) >= 1.1.19
BuildRequires: pkgconfig(sqlite3) >= 3.7.0
BuildRequires: pkgconfig(libsoup-2.4) >= 2.28.2 pkgconfig(webkitgtk-3.0) pkgconfig(json-glib-1.0)
BuildRequires: pkgconfig(gobject-introspection-1.0) gir(Gtk) = 3.0
BuildRequires: pkgconfig(gsettings-desktop-schemas)
BuildRequires: pkgconfig(libpeas-1.0) >= 1.0.0 pkgconfig(libpeas-gtk-1.0) >= 1.0.0
%{?_enable_libnotify:BuildRequires: pkgconfig(libnotify) >= 0.7}

%set_typelibdir %_libdir/%name/girepository-1.0

%description
Liferea is a simple FeedReader clone for Unix distributions with GTK3
(GNOME3 is optional). It is a news aggregator for RSS/RDF feeds which
also supports CDF channels, Atom/Echo/PIE feeds and OCS or OPML
directories. The problem with FeedReader: for now its only available
for Windows. There are some projects for GNU/Linux, but no solution for
GTK/GNOME, which does not require Python or Perl. Liferea tries to fill
this gap. Liferea is an abbreviation for Linux Feed Reader.

%package plugins-gnome-keyring
Summary: GNOME Keyring Support for the %name
Group: Networking/News
Requires: %name = %version-%release

%description plugins-gnome-keyring
Allow Liferea to use GNOME keyring as password store

%package plugins-media-player
Summary: Play music and videos directly from Liferea
Group: Networking/News
Requires: %name = %version-%release

%description plugins-media-player
Play music and videos directly from Liferea

%prep
%setup -q
%patch -p1

%build
%autoreconf
%configure \
	--enable-introspection \
	%{subst_enable libnotify} \
	--disable-static
%make_build

%install
%make DESTDIR=%buildroot install

%find_lang --with-gnome %name

%files -f %name.lang
%doc AUTHORS COPYING ChangeLog
%dir %_libdir/%name/plugins
%_bindir/*
%_libdir/%name/girepository-1.0/*.typelib
%_datadir/%name
%_datadir/glib-2.0/schemas/*.xml
%_datadir/GConf/gsettings/%name.convert
%_datadir/appdata/%name.appdata.xml
%_datadir/applications/%name.desktop
%_datadir/icons/hicolor/*/apps/*
%_man1dir/%name.*

%files plugins-gnome-keyring
%_libdir/%name/plugins/gnome-keyring.*

%files plugins-media-player
%_libdir/%name/plugins/media-player.*

%changelog
