%def_with mysql
%def_with ssl
%def_with ldap
%def_with memcached
%def_with lua
%def_with gamin
%def_with tests

%define lighttpd_user lighttpd
%define lighttpd_group lighttpd
%define lighttpd_spool %_spooldir/%name

%define docdir %_docdir/%name-%version-doc

Name: lighttpd
Version: 1.4.54
Release: alt0.M80P.1

Packager: Alexei Takaseev <taf@altlinux.ru>

Summary: A fast webserver with minimal memory-footprint
License: BSD
Group: System/Servers

# git svn init -Ttrunk -ttags -bbranches svn://svn.lighttpd.net/lighttpd/
Url: http://www.lighttpd.net

Source0: %name-%version.tar
Patch0: %name-%version-%release.patch

Requires(pre): shadow-utils shadow-groups webserver-common
Provides: webserver

BuildRequires(pre): rpm-macros-webserver-common
# Automatically added by buildreq on Wed Sep 02 2009
BuildRequires: bzlib-devel libfcgi-devel libpcre-devel zlib-devel

%{?_with_mysql:BuildPreReq: libmysqlclient-devel}
%{?_with_ssl:BuildPreReq: libssl-devel}
%{?_with_ldap:BuildPreReq: libldap-devel}
%{?_with_memcached:BuildPreReq: libmemcached-devel}
%{?_with_lua:BuildPreReq:liblua5-devel}
%{?_with_gamin:BuildPreReq: libgamin-devel}
%{?_with_tests:BuildPreReq: perl-devel perl-Digest-SHA}

%description
%name is intented to be a frontend for ad-servers which have to deliver
small files concurrently to many connections.

%package mysql-vhost
Summary: MySQL based vhosting %name module
Group: System/Servers
Requires: %name = %version-%release

%description mysql-vhost
This module provides virtual hosts (vhosts) based on a MySQL table.

%package cml
Summary: CML (Cache Meta Language) %name module
Group: System/Servers
Requires: %name = %version-%release

%description cml
CML is a Meta language to describe the dependencies of a page at one side and
building a page from its fragments on the other side using LUA. 

%package trigger_b4_dl
Summary: another anti hot-linking %name module
Group: System/Servers
Requires: %name = %version-%release

%description trigger_b4_dl
another anti hot-linking module.

%package rrdtool
Summary: rrdtool support %name module
Group: System/Servers
Requires: %name = %version-%release, rrdtool

%description rrdtool
mod_rrdtool is used to monitor the traffic and load on the webserver.

%package doc
Summary: %name documentation
Group: Documentation
BuildArch: noarch

%description doc
Documentation for %name.

%prep
%setup
%patch0 -p1

libtoolize -f -c
%autoreconf

%build
%configure --libdir=%_libdir/%name \
    %{?_with_mysql:       --with-mysql} \
    %{?_with_ssl:         --with-openssl} \
    %{?_with_ldap:	  --with-ldap} \
    %{?_with_memcached:	  --with-memcached} \
    %{?_with_lua:	  --with-lua} \
    %{?_with_gamin:	  --with-fam} \
    %{?_with_lua:	  LUA_CFLAGS="-I/usr/include/" LUA_LIBS="-llua"}
%make_build

# run tests for sanity checks
#pushd tests
#./wrapper.sh . .. ./prepare.sh
#./wrapper.sh . .. ./run-tests.pl
#popd

%install
%makeinstall libdir=%buildroot%_libdir/%name

mkdir -p %buildroot%_sysconfdir/{rc.d/init.d,sysconfig}
mkdir -p %buildroot%_unitdir
mkdir -p %buildroot{%_spooldir/%name/tmp,%_var/log/%name,%_var/lib/%name}

# inirscript, sysconfig and unit
install -m755 %name.init %buildroot%_initdir/%name
#install -m644 doc/initscripts/sysconfig.lighttpd %buildroot%_sysconfdir/sysconfig/lighttpd
install -m644 doc/systemd/lighttpd.service %buildroot%_unitdir/lighttpd.service

# configs
cp -rp doc/config %buildroot%_sysconfdir/%name
find %buildroot%_sysconfdir/%name -type f -name "Makefile*" -delete

# logrotate script
install -pDm644 lighttpd.logrotate %buildroot%_sysconfdir/logrotate.d/%name

# docs
rm -rf %buildroot%docdir
mkdir -p %buildroot%docdir/outdated
cp -a doc/outdated/*.txt %buildroot%docdir/outdated/

%if_with tests
%check
%make -C tests leak-check
%endif #tests

%pre
%_sbindir/groupadd -r -f %lighttpd_group ||:
%_sbindir/useradd -r -g %lighttpd_group -d /dev/null -s /dev/null -n %lighttpd_user \
	2> /dev/null > /dev/null ||:
gpasswd -a %lighttpd_user %webserver_group

%post
%post_service lighttpd

%preun
%preun_service lighttpd

%files
%doc README INSTALL COPYING AUTHORS
%config %_initdir/%name
#%config(noreplace) %_sysconfdir/sysconfig/lighttpd
%config(noreplace) %_sysconfdir/logrotate.d/%name
%_unitdir/*
%dir %attr(0750,root,%lighttpd_group) %_sysconfdir/%name
%dir %attr(0750,root,%lighttpd_group) %_sysconfdir/%name/conf.d
%dir %attr(0750,root,%lighttpd_group) %_sysconfdir/%name/vhosts.d
%config(noreplace) %attr(0644,root,%lighttpd_group) %_sysconfdir/%name/*.conf
%config(noreplace) %attr(0644,root,%lighttpd_group) %_sysconfdir/%name/*/*.conf
%_sysconfdir/%name/*/mod.template
%_sysconfdir/%name/vhosts.d/*
%_man8dir/*
%dir %attr(1770,root,%lighttpd_group) %lighttpd_spool
%dir %attr(1770,root,%lighttpd_group) %lighttpd_spool/tmp
%dir %attr(1770,root,%lighttpd_group) %_var/lib/%name
%dir %attr(1770,root,%lighttpd_group) %_var/log/%name
%dir %_libdir/%name
%_libdir/%name/*.so
%if_with mysql
%exclude %_libdir/%name/*_mysql_vhost.so
%endif #mysql
%if_with lua
%exclude %_libdir/%name/*_cml.so
%endif #cml
%if_with memcached
%exclude %_libdir/%name/*_trigger_b4_dl.so
%endif #trigger_b4_dl
%exclude %_libdir/%name/*_rrdtool.so
%_sbindir/*
%exclude %_libdir/%name/*.la

%files doc
%docdir

%if_with mysql
%files mysql-vhost
%_libdir/%name/*mysql_vhost.so
%endif #mysql

%if_with lua
%files cml
%_libdir/%name/*cml.so
%endif lua

%if_with memcached
%files trigger_b4_dl
%_libdir/%name/*trigger_b4_dl.so
%endif #memcached

%files rrdtool
%_libdir/%name/*rrdtool.so

%changelog
