%def_disable java
# don't use aspell as Abiword uses hanspell via libenchant
%def_disable aspell
%def_enable hunspell
%def_disable perl
%def_enable system_minisat

%define dictdir %_datadir/myspell

Name: link-grammar
Version: 5.3.14
Release: alt0.M80P.1

Summary: The link grammar parsing system for Unix
License: GPL-compatible
Group: Text tools
Url: http://www.link.cs.cmu.edu/link/

Source: http://www.abisource.com/downloads/%name/%version/%name-%version.tar.gz
Patch: link-grammar-5.3.9-alt-man_build.patch

Requires: lib%name = %version-%release

BuildRequires: gcc-c++ autoconf-archive swig
BuildRequires: libedit-devel libsqlite3-devel zlib-devel
%{?_enable_aspell:BuildRequires:libaspell-devel}
%{?_enable_hunspell:BuildRequires:libhunspell-devel}
%{?_enable_perl:BuildRequires: perl-devel}
%{?_enable_system_minisat:BuildRequires:libminisat-devel}

%description
The link grammar parsing system for Unix.

%package -n lib%name
Summary: Library files for %name
Group: System/Libraries

%description -n lib%name
Library files for %name

%package -n lib%name-devel
Summary: Development files needed to build applications with %name
Group: Development/C
Requires: lib%name = %version-%release

%description -n lib%name-devel
Development files needed to build applications with %name.

%package -n perl-%name
Summary: Perl bindings for %name
Group: Development/Perl
Requires: lib%name = %version-%release

%description -n perl-%name
Perl bindings for %name library.

%prep
%setup
%patch -b .man

%build
%autoreconf
%configure \
	--with-hunspell-dictdir=%dictdir \
	%{?_disable_java:--disable-java-bindings} \
	%{subst_enable aspell} \
	%{subst_enable hunspell} \
	%{?_disable_system_minisat:--enable-sat-solver=bundled}
%make_build

%install
%makeinstall_std

%files
%_bindir/link-parser
%_man1dir/link-parser.1*
%doc LICENSE README ChangeLog

%files -n lib%name
%dir %_datadir/%name/
%_datadir/%name/*
%_libdir/*.so.*

%files -n lib%name-devel
%dir %_includedir/%name/
%_includedir/%name/*
%_libdir/*.so
%_pkgconfigdir/%name.pc
%exclude %_libdir/*.a

%if_enabled perl
%files -n perl-%name
%perl_vendor_privlib/*
%endif

%changelog
