Name: linphone
Version: 3.10.2
Release: alt1
License: GPLv2+
Url: http://www.linphone.org/

Summary: Open source video SIP phone
Group: Communications

Packager: Alexei Takaseev <taf@altlinux.ru>

Source0: %name-%version.tar
#Patch0: %name-%version-%release.patch
BuildPreReq: libortp-devel >= 0.16
BuildRequires: gcc-c++
BuildRequires: doxygen intltool libexosip2-devel libglade-devel libgsm-devel
BuildRequires: libnotify-devel libssl-devel libbelle-sip-devel
BuildRequires: libmediastreamer-devel libreadline-devel libspeex-devel
BuildRequires: libSDL-devel libosip2-devel >= 3.5.0 libncurses-devel
BuildRequires: libxml2-devel libsqlite3-devel

Requires: %name-gui = %version-%release
Requires: %name-cli = %version-%release

%description
Linphone is a SIP compliant audio & video phone. It can be used to run calls 
over the internet. It has a gtk+ and console interface.

%package common
Summary: Common files for %name
Group: Communications

%description common
Linphone is a SIP compliant audio & video phone. It can be used to run calls 
over the internet. It has a gtk+ and console interface.

This package contains common files for %name.

%package gui
Summary: Open source video SIP phone, graphical interface
Group: Communications
Requires: %name-common = %version-%release

%description gui
Linphone is a SIP compliant audio & video phone. It can be used to run calls 
over the internet. It has a gtk+ and console interface.

This package contains graphical interface of %name.

%package cli
Summary: Open source video SIP phone, console interface
Group: Communications
Requires: %name-common = %version-%release

%description cli
Linphone is a SIP compliant audio & video phone. It can be used to run calls 
over the internet. It has a gtk+ and console interface.

This package contains console interface for %name.

%package tester
Summary: This is the test suite of liblinphone.
Group: Communications
Requires: %name-cli = %version-%release

%description tester
This is the test suite of liblinphone, with many tests suites
for Register, Calls, Message, Presence.

All thoses tests suites require a SIP server configured
accordingly in order to execute.

%package devel
Summary: Development files for %name
Group: Communications

%description devel
Linphone is a SIP compliant audio & video phone. It can be used to run calls 
over the internet. It has a gtk+ and console interface.

This package contains development files for %name.

%prep
%setup
#%%patch0 -p1
./autogen.sh

%build
%configure --enable-external-ortp \
 --enable-external-mediastreamer \
 --enable-notify \
 --enable-ssl \
 --disable-static

%make_build

%install
%makeinstall_std
%find_lang %name

%files

%files common
%doc AUTHORS ChangeLog NEWS README TODO
%_libdir/*.so.*
%exclude %_docdir/%name-%version
%exclude %_datadir/gnome
%exclude %_mandir/cs
%exclude %_man1dir/sipomatic.1*

%files gui -f %name.lang
%_bindir/linphone
%_desktopdir/%name.desktop
%_desktopdir/audio-assistant.desktop
%_pixmapsdir/%name
%_iconsdir/hicolor/*/*/%{name}*.*
%_man1dir/linphone.1*
%_datadir/sounds/%name
%_datadir/%name
%_datadir/appdata/%name.appdata.xml


%files cli
%_bindir/linphonec
%_bindir/linphonecsh
%_bindir/linphone-daemon
%_bindir/lp-sendmsg
%_bindir/lp-autoanswer
%_bindir/lp-gen-wrappers
%_man1dir/linphonec.1*
%_man1dir/linphonecsh.1*

%files devel
%doc coreapi/help/doc/html/*
%doc coreapi/help/*.c
%doc coreapi/help/java
%_pkgconfigdir/*
%_includedir/*
%_libdir/*.so
%_datadir/tutorials/%name

%files tester
%doc tester/README
%_bindir/liblinphone_tester
%_bindir/linphone-daemon-pipetest
%_bindir/lp-test-ecc
%_bindir/lpc2xml_test
%_bindir/xml2lpc_test
%_datadir/lib%{name}_tester


%changelog
