Summary: A text formatting package based on SGML
Name: linuxdoc-tools
Version: 0.9.69
Release: alt1
License: GPL
Group: Publishing
Source: http://http.us.debian.org/debian/pool/main/l/linuxdoc-tools/%{name}_%version.tar.gz
Patch0: linuxdoc-tools-0.9.13-letter.patch
Patch1: linuxdoc-tools-0.9.20-lib64.patch
Url: http://packages.qa.debian.org/l/linuxdoc-tools.html
Packager: Eugeny A. Rostovtsev (REAL) <real at altlinux.org>

BuildRequires: flex sgml-common jade groff texinfo OpenSP
BuildPreReq: texlive-latex-recommended

Requires: groff-base sgml-common

Provides: sgml-tools = %version-%release
Obsoletes: sgml-tools

%description
Linuxdoc-tools is a text formatting suite based on SGML (Standard
Generalized Markup Language), using the LinuxDoc document type.
Linuxdoc-tools allows you to produce LaTeX, HTML, GNU info, LyX, RTF,
plain text (via groff), and other format outputs from a single SGML
source.  Linuxdoc-tools is intended for writing technical software
documentation.

%prep
%setup
%patch0 -p1
%patch1 -p1 -b .lib64

%build
%configure --with-installed-nsgmls --with-installed-iso-entities
# Packaging brain-damage
pushd entity-map
autoconf
%configure
popd

%make_build OPTIMIZE="%optflags"
perl -pi -e \
	's,\$main::prefix/share/sgml/iso-entities-8879.1986/iso-entities.cat,%_datadir/sgml/sgml-iso-entities-8879.1986/catalog,' \
	perl5lib/LinuxDocTools.pm

%install
install -d %buildroot%perl_vendorlib
%makeinstall_std perl5libdir=%perl_vendorlib
mv %buildroot%_docdir/%name %buildroot%_docdir/%name-%version
perl -pi -e \
	's,%_datadir/sgml/iso-entities-8879.1986/iso-entities.cat,\$main::prefix/share/sgml/sgml-iso-entities-8879.1986/catalog,' \
 	%buildroot%perl_vendorlib/LinuxDocTools.pm

#Copy license files for parts into docdir
install -d %buildroot%_docdir/%name-%version/sgmls-1.1
cp -p sgmls-1.1/LICENSE \
	%buildroot%_docdir/%name-%version/sgmls-1.1/LICENSE
install -d %buildroot%_docdir/%name-%version/iso-entities
cp -p iso-entities/COPYING \
	%buildroot%_docdir/%name-%version/iso-entities/COPYING
install -d %buildroot%_docdir/%name-%version/entity-map
cp -p entity-map/COPYING \
	%buildroot%_docdir/%name-%version/entity-map/COPYING
cp -p COPYING %buildroot%_docdir/%name-%version/


# Some files need moving around.
rm -f %buildroot%_datadir/%name/epsf.*
rm -f %buildroot%_datadir/%name/url.sty
install -d %buildroot%_datadir/texmf/tex/latex/misc
mv %buildroot%_datadir/%name/*.sty \
  %buildroot%_datadir/texmf/tex/latex/misc

%files
%doc %_docdir/%name-%version
%_bindir/*
%_datadir/%name
%_datadir/entity-map
%_datadir/texmf/tex/latex/misc/*.sty
%dir %perl_vendorlib/Text
%dir %perl_vendorlib/LinuxDocTools
%perl_vendorlib/Text/EntityMap.pm
%perl_vendorlib/LinuxDocTools.pm
%perl_vendorlib/LinuxDocTools/*.pm
%_mandir/*/*

%changelog
