Name: lirc
Version: 0.9.3a
Release: alt1.2

Summary: The Linux Infrared Remote Control package
License: GPL
Group: System/Base
Url: http://www.lirc.org

Source: %name-%version.tar
Source1: lircd
Source2: lircd.sysconfig
Source3: lircd.service
Source4: liblircclient0.pc

Patch2: lirc-0.9.3a-mode2-fix-sigsegv.patch
Patch3: lirc-0.9.2a-linking.patch

Obsoletes: %name-remotes

BuildRequires: libX11-devel libalsa-devel libftdi-devel python3 rpm-build-python3 xsltproc gcc-c++

Requires: liblirc = %version-%release

%description
LIRC is a package that allows you to decode and send infra-red signals
of many (but not all) commonly used remote controls.

%package -n liblirc
Summary: Client library for LIRC
Group: System/Libraries

%description -n liblirc
Libraries needed by programs, which uses LIRC

%package -n liblirc-devel
Summary: Development for LIRC
Group: Development/C
Requires: lib%name = %version-%release

%description -n liblirc-devel
Development library for LIRC

%package config
Summary: LIRC Configuration Tools and Data
Requires: lirc = %version-%release
BuildArch: noarch
Group: System/Base

%description config
The LIRC config package contains tools and data  to ease the
LIRC configuration process.

%prep
%setup
%patch2 -p2
%patch3 -p2

for f in NEWS ChangeLog AUTHORS contrib/lircrc ; do
    iconv -f iso-8859-1 -t utf-8 $f > $f.utf8 ; mv $f.utf8 $f
done

%build
%add_optflags -I%_includedir/libftdi
%autoreconf
%configure  --disable-static --localstatedir=%_var \
	    --with-x --with-syslog --with-driver=userspace \
	    --with-port=0x3f8 --with-irq=4
make

%install
%makeinstall varrundir=%buildroot/%_runtimedir docdir=%buildroot%_defaultdocdir/%name-%version
install -pm755 -D %SOURCE1 %buildroot%_initdir/lircd
install -pm644 -D %SOURCE2 %buildroot%_sysconfdir/sysconfig/lircd
install -pm644 -D %SOURCE3 %buildroot%systemd_unitdir/lircd.service
install -pm644 -D %SOURCE4 %buildroot%_datadir/pkgconfig/liblircclient0.pc
mkdir -p %buildroot/%_runtimedir/lirc %buildroot%_tmpfilesdir
echo 'd /var/run/lirc 0755 root root' > %buildroot%_tmpfilesdir/lirc.conf
# relocate to docdir to avoid python deps
rm -f %buildroot%_bindir/pronto2lirc
rm -rf %buildroot%_datadir/lirc/contrib
mv %buildroot/%_libdir/pkgconfig/* %buildroot%_datadir/pkgconfig/
sed -i -e '/^plugindir/s|%buildroot||' %buildroot%_sysconfdir/lirc/lirc_options.conf



%triggerun -- lirc < 0.9.2
if [ $2 -gt 0 ] && [ $1 -gt 0 ] && [ -f /etc/lircd.conf ]; then
# This is upgrade.
	echo "Warning: configuration files from /etc/lirc.conf moved to /etc/lirc/lircd.conf.d/lircd-saved.conf"
	mkdir -p %_sysconfdir/lirc/lirc.conf.d >dev/null 2>&1 ||:
	mv /etc/lircd.conf /etc/lirc/lircd.conf.d/lircd-saved.conf ||:
	%post_service lircd
fi


%pre
/usr/sbin/groupadd -r -f %name &> /dev/null ||:

%post
%post_service lircd

%preun
%preun_service lircd
%files
%doc NEWS doc/irxevent.keys doc/html configs contrib
%config(noreplace) %_sysconfdir/sysconfig/lircd
%config(noreplace) %_sysconfdir/lirc/*
%dir %_sysconfdir/lirc
%systemd_unitdir/lircd.service
%_initdir/*
%_bindir/*
%exclude %_bindir/irdb-get
%exclude %_bindir/lirc-config-tool
%exclude %_bindir/lirc-setup
%attr(2711,root,%name) %_sbindir/lircd
%_sbindir/lircmd
%_sbindir/lirc-lsplugins
%_man1dir/*.1*
%exclude %_mandir/man1/irdb-get*
%exclude %_mandir/man1/lirc-config-tool*
%exclude %_mandir/man1/lirc-setup*
#_man4dir/*.4*
%_man5dir/*.5*
%_man8dir/*.8*
%_tmpfilesdir/lirc.conf
%_runtimedir/lirc
%_datadir/lirc/plugindocs/*

%files -n liblirc
%_libdir/liblirc_client.so.*
%_libdir/liblirc.so.*
%_libdir/libirrecord.so.*
%_libdir/liblirc_driver.so.*
%_libdir/lirc

%files -n liblirc-devel
%_libdir/*.so
%_includedir/*
%_datadir/pkgconfig/*

%files config
%_bindir/irdb-get
%_bindir/lirc-config-tool
%_bindir/lirc-setup
%_mandir/man1/irdb-get*
%_mandir/man1/lirc-config-tool*
%_mandir/man1/lirc-setup*
%_datadir/lirc/configs/*
%python3_sitelibdir_noarch/lirc
%exclude %_datadir/lirc/configs/iguanaIR.conf
%exclude %_datadir/lirc/configs/irman.conf
%exclude %_datadir/lirc/configs/ftdi.conf
%exclude %_datadir/lirc/configs/audio.conf

%changelog
