%global v_major 6.0
%global llvm_svnrel %nil
%global clang_svnrel %nil
%global rel alt0.6.M80P.1
%global llvm_name llvm%v_major
%global clang_name clang%v_major
%global lld_name lld

# Decrease debuginfo verbosity to reduce memory consumption during final library linking
%global optflags %(echo %{optflags} | sed 's/-g /-g1 /')

%ifndef build_parallel_jobs
%global build_parallel_jobs 8
%endif

%def_disable tests
%def_with clang

# do not overscale this on systems with less cores
# on i586 and maybe on memory constrained x86_64
#%%if %__nprocs < %build_parallel_jobs
#%%define build_parallel_jobs %__nprocs
#%%endif

Name: %llvm_name
Version: 6.0.0
Release: %rel.rel
Summary: The Low Level Virtual Machine

Group: Development/C
License: NCSA
Url: http://llvm.org
Source0: http://llvm.org/releases/%version/llvm-%version.tar
Source1: http://llvm.org/releases/%version/clang-%version.tar
Source2: http://llvm.org/releases/%version/lld-%version.tar
Source3: http://llvm.org/releases/%version/compiler-rt-%version.tar
Patch:  clang-alt-i586-fallback.patch
Patch1: clang-alt-triple.patch
Patch2: llvm-alt-cmake-path.patch
Patch3: llvm-alt-fix-linking.patch
Patch4: llvm-alt-triple.patch
Patch5: compiler-rt-alt-i586-arch.patch
Patch6: RH-0001-CMake-Split-static-library-exports-into-their-own-ex.patch
Patch7: 0001-DebugInfo-Discard-invalid-DBG_VALUE-instructions-in-.patch
Patch8: 0001-Fixup-for-rL326769-RegState-Debug-is-being-truncated.patch

# ThinLTO requires /proc/cpuinfo to exists so the same does llvm
BuildPreReq: /proc

BuildRequires(pre): cmake >= 3.4.3
BuildRequires: chrpath libstdc++-devel libffi-devel perl-Pod-Parser perl-devel
BuildRequires: python-modules-compiler python-modules-unittest python-modules-xml
BuildRequires: python-modules-json zip zlib-devel
BuildRequires: python-module-sphinx-devel binutils-devel
BuildRequires: ninja-build
%if_with clang
BuildRequires: %clang_name %llvm_name-devel %lld_name
# FIXME!!
# this should be fixed in rpm macros
%remove_optflags -frecord-gcc-switches

%else
BuildRequires: gcc-c++
%endif #with clang

Provides: llvm = %EVR
Conflicts: llvm <= 4.0.1
Conflicts: llvm4.0

%description
LLVM is a compiler infrastructure designed for compile-time, link-time,
runtime, and idle-time optimization of programs from arbitrary
programming languages. The compiler infrastructure includes mirror sets
of programming tools as well as libraries with equivalent functionality.

%package devel
Group: Development/C
Summary: Libraries and header files for LLVM
Provides: llvm-devel = %EVR
Obsoletes: llvm-devel <= 4.0.1
Requires: %name = %EVR
Conflicts: llvm4.0-devel

%description devel
This package contains library and header files needed to develop new
native programs that use the LLVM infrastructure.

%package devel-static
Summary: Static libraries for LLVM
Group: Development/C
Provides: llvm-devel-static = %EVR
Obsoletes: llvm-devel-static <= 4.0.1
Requires: %name-devel = %EVR
Conflicts: llvm4.0-devel-static

%description devel-static
This package contains static libraries needed to develop new
native programs that use the LLVM infrastructure.

%package libs
Group: Development/C
Summary: LLVM shared libraries
Conflicts: llvm4.0-libs

%description libs
Shared libraries for the LLVM compiler infrastructure.

%package doc
Summary: Documentation for LLVM
Group: Documentation
BuildArch: noarch
Provides: llvm-doc = %EVR
Obsoletes: llvm-doc <= 4.0.1
Conflicts: llvm4.0-doc

%description doc
Documentation for the LLVM compiler infrastructure.

%package -n %clang_name
Summary: A C language family frontend for LLVM
License: NCSA
Group: Development/C
Requires: gcc
Provides: clang = %EVR
Obsoletes: clang <= 4.0.1
Conflicts: clang4.0

%description -n %clang_name
clang: noun
    1. A loud, resonant, metallic sound.
    2. The strident call of a crane or goose.
    3. C-language family front-end toolkit.

The goal of the Clang project is to create a new C, C++, Objective C
and Objective C++ front-end for the LLVM compiler. Its tools are built
as libraries and designed to be loosely-coupled and extendable.

%package -n %clang_name-libs
Group: Development/C
Summary: clang shared libraries

%description -n %clang_name-libs
Shared libraries for the clang compiler.

%package -n %clang_name-devel
Summary: Header files for clang
Group: Development/C
Provides: clang-devel = %EVR
Obsoletes: clang-devel <= 4.0.1
Requires: %clang_name = %EVR
Conflicts: clang4.0-devel

%description -n %clang_name-devel
This package contains header files for the Clang compiler.

%package -n %clang_name-devel-static
Summary: Static libraries for clang
Group: Development/C
Provides: clang-devel-static = %EVR
Obsoletes: clang-devel-static <= 4.0.1
Requires: %clang_name = %EVR
Conflicts: clang4.0-devel-static

%description -n %clang_name-devel-static
This package contains static libraries for the Clang compiler.

%package -n %clang_name-analyzer
Summary: A source code analysis framework
License: NCSA
Group: Development/C
BuildArch: noarch
Provides: clang-analyzer = %EVR
Obsoletes: clang-analyzer <= 4.0.1
Requires: %clang_name = %EVR
Conflicts: clang4.0-analyzer

%description -n %clang_name-analyzer
The Clang Static Analyzer consists of both a source code analysis
framework and a standalone tool that finds bugs in C and Objective-C
programs. The standalone tool is invoked from the command-line, and is
intended to run in tandem with a build of a project or code base.

%package -n %clang_name-doc
Summary: Documentation for Clang
Group: Documentation
BuildArch: noarch
Provides: clang-doc = %EVR
Obsoletes: clang-doc <= 4.0.1
Conflicts: clang4.0-doc

%description -n %clang_name-doc
Documentation for the Clang compiler front-end.

%package -n %lld_name
Summary: LLD - The LLVM Linker
License: NCSA
Group: Development/C
Provides: lld%v_major = %EVR

%description -n %lld_name
LLD is a linker from the LLVM project. That is a drop-in replacement for system
linkers and runs much faster than them. It also provides features that are
useful for toolchain developers.

%package -n %lld_name-devel
Summary: Header files for LLD
Group: Development/C
Provides: lld%v_major-devel = %EVR
Requires: %lld_name = %EVR

%description -n %lld_name-devel
This package contains header files for the LLD linker.

%package -n %lld_name-doc
Summary: Documentation for LLD
Group: Documentation
BuildArch: noarch
Provides: lld%v_major-doc = %EVR

%description -n %lld_name-doc
Documentation for the LLD linker.

%prep
%setup -n llvm-%version -a1 -a2 -a3
for pkg in clang lld; do
   mv $pkg-%version tools/$pkg
done
mv compiler-rt-%version projects/compiler-rt
%patch -p1
%patch1 -p1
%patch2 -p1
%patch3 -p1
%patch4 -p1
%patch5 -p1
%patch6 -p1
%patch7 -p1
%patch8 -p1

%build
%cmake -G Ninja \
	-DCMAKE_BUILD_TYPE=Release \
	-DBUILD_SHARED_LIBS:BOOL=OFF \
	-DLLVM_TARGETS_TO_BUILD="host;AMDGPU;BPF;" \
	-DLLVM_EXPERIMENTAL_TARGETS_TO_BUILD='AVR' \
	-DLLVM_ENABLE_LIBCXX:BOOL=OFF \
	-DLLVM_ENABLE_ZLIB:BOOL=ON \
	-DLLVM_ENABLE_FFI:BOOL=ON \
	-DLLVM_ENABLE_RTTI:BOOL=ON \
	-DLLVM_OPTIMIZED_TABLEGEN:BOOL=ON \
	-DLLVM_BINUTILS_INCDIR="%_includedir/bfd" \
	%if_with clang
	-DLLVM_ENABLE_LTO=Thin \
	-DCMAKE_C_COMPILER=clang \
	-DCMAKE_CXX_COMPILER=clang++ \
	-DCMAKE_RANLIB:PATH=%_bindir/llvm-ranlib \
	-DCMAKE_AR:PATH=%_bindir/llvm-ar \
	-DCMAKE_NM:PATH=%_bindir/llvm-nm \
	-DLLVM_ENABLE_LLD:BOOL=ON \
	%else
	-DLLVM_ENABLE_LTO=On \
	-DLLVM_USE_LINKER=gold \
	-DCMAKE_AR:PATH=%_bindir/gcc-ar \
	-DCMAKE_NM:PATH=%_bindir/gcc-nm \
	-DCMAKE_RANLIB:PATH=%_bindir/gcc-ranlib \
	-DCMAKE_SHARED_LINKER_FLAGS="-Wl,-Bsymbolic" \
	%endif
	\
	%if "%_lib" == "lib64"
	-DLLVM_LIBDIR_SUFFIX="64" \
	%else
	-DLLVM_LIBDIR_SUFFIX="" \
	%endif
	-DLLVM_BUILD_RUNTIME:BOOL=ON \
	\
	-DLLVM_INCLUDE_TOOLS:BOOL=ON \
	-DLLVM_BUILD_TOOLS:BOOL=ON \
	\
	%if_enabled tests
	-DLLVM_INCLUDE_TESTS:BOOL=ON \
	-DLLVM_BUILD_TESTS:BOOL=ON \
	%endif
	\
	-DLLVM_INCLUDE_EXAMPLES:BOOL=ON \
	-DLLVM_BUILD_EXAMPLES:BOOL=OFF \
	\
	-DLLVM_INCLUDE_UTILS:BOOL=ON \
	-DLLVM_INSTALL_UTILS:BOOL=OFF \
	\
	-DLLVM_INCLUDE_DOCS:BOOL=ON \
	-DLLVM_BUILD_DOCS:BOOL=ON \
	-DLLVM_ENABLE_SPHINX:BOOL=ON \
	-DSPHINX_WARNINGS_AS_ERRORS:BOOL=OFF \
	-DLLVM_ENABLE_DOXYGEN:BOOL=OFF \
	-DLLVM_BUILD_LLVM_DYLIB:BOOL=ON \
	-DLLVM_DYLIB_EXPORT_ALL:BOOL=ON \
	-DLLVM_LINK_LLVM_DYLIB:BOOL=ON \
	-DLLVM_INSTALL_TOOLCHAIN_ONLY:BOOL=OFF

ninja \
       -vvv \
       -j %build_parallel_jobs \
       -C BUILD

%install
pushd BUILD
cmake -DCMAKE_INSTALL_PREFIX=%buildroot%prefix ../
popd
ninja -C BUILD install

# And prepare Clang documentation
rm -rf BUILD/clang-docs
mkdir -p BUILD/clang-docs
for f in LICENSE.TXT NOTES.txt README.txt; do
  ln tools/clang/$f BUILD/clang-docs/
done
rm -rf tools/clang/docs/{doxygen*,Makefile*,*.graffle,tools}

file %buildroot%_bindir/* | awk -F: '$2~/ELF/{print $1}' | xargs -r chrpath -d
file %buildroot%_libdir/*.so | awk -F: '$2~/ELF/{print $1}' | xargs -r chrpath -d

%check
%if_enabled tests
LD_LIBRARY_PATH=%buildroot%_libdir:$LD_LIBRARY_PATH
export LD_LIBRARY_PATH
ninja -C BUILD check-all || :
%endif

%files
%doc CREDITS.TXT LICENSE.TXT README.txt
%_bindir/*
%_man1dir/*
%exclude %_bindir/llvm-config*
%exclude %_bindir/*clang*
%exclude %_bindir/c-index-test
%exclude %_bindir/scan-*
%exclude %_man1dir/llvm-config.1.*
%exclude %_man1dir/clang.1*
%exclude %_man1dir/scan-build.1*
%exclude %_bindir/lld*
%exclude %_bindir/ld*.lld
%exclude %_bindir/wasm-ld

%files libs
%_libdir/libLLVM-*.so
%_libdir/libLTO.so.*
%exclude %_libdir/LLVMgold.so
%exclude %_libdir/libclang.so.*

%files devel
%_bindir/llvm-config
%_man1dir/llvm-config.1.*
%_includedir/llvm
%_includedir/llvm-c
%_libdir/libLLVM.so
%_libdir/libLTO.so
%_libdir/LLVMgold.so
%_libdir/LLVMHello.so
%_libdir/BugpointPasses.so
%exclude %_libdir/libclang.so
%_datadir/cmake/Modules/llvm

%files devel-static
%_libdir/*.a
%exclude %_libdir/libclang*.a

%files doc
%doc %_docdir/llvm

%files -n %clang_name
%doc BUILD/clang-docs/*
%_bindir/*clang*
%_bindir/c-index-test
%_libdir/clang
%_man1dir/clang.1*

%files -n %clang_name-libs
%_libdir/libclang.so.*

%files -n %clang_name-devel
%_includedir/clang
%_includedir/clang-c
%_libdir/libclang.so
%_datadir/cmake/Modules/clang

%files -n %clang_name-devel-static
%_libdir/libclang*.a

%files -n %clang_name-analyzer
%_prefix/libexec/*-analyzer
%_bindir/scan-build
%_bindir/scan-view
%_datadir/scan-build
%_datadir/scan-view
%_man1dir/scan-build.1*

%files -n %clang_name-doc
%doc %_docdir/clang

%files -n %lld_name
%_bindir/lld*
%_bindir/ld*.lld
%_bindir/wasm-ld

%files -n %lld_name-devel
%dir %_includedir/lld
%_includedir/lld/*

%files -n %lld_name-doc
%doc %_docdir/lld

%changelog
