Name: lockdev
Version: 1.0.3
Release: alt3.1.1

Summary: A library and a command-line tool for locking devices
License: LGPL
Group: System/Libraries

URL: http://packages.debian.org/unstable/source/lockdev
Source: %name-%version.tar
Patch: %name-%version-%release.patch

Requires: lib%name = %version-%release
Requires: /var/lock/serial

# Automatically added by buildreq on Mon Oct 17 2011
BuildRequires: perl-devel

%description
The lockdev library provides a reliable way to put an exclusive lock
on devices using both FSSTND and SVr4 methods.

%package -n lib%name
Summary: A library for locking devices
Group: System/Libraries

%description -n lib%name
The lockdev library provides a reliable way to put an exclusive lock
on devices using both FSSTND and SVr4 methods.

%package -n lib%name-devel
Summary: Header files for the %name library
Group: Development/C
Requires: lib%name = %version-%release

%description -n lib%name-devel
The lockdev library provides a reliable way to put an exclusive lock
on devices using both FSSTND and SVr4 methods.

%package -n lib%name-devel-static
Summary: Static %name library
Group: Development/C
Requires: lib%name = %version-%release

%description -n lib%name-devel-static
The lockdev library provides a reliable way to put an exclusive lock
on devices using both FSSTND and SVr4 methods.

%package -n perl-LockDev
Summary: Perl interface for the %name library
Group: Development/Perl
Requires: lib%name = %version-%release
Provides: %name-perl = %version
Obsoletes: %name-perl < %version

%description -n perl-LockDev
The lockdev library provides a reliable way to put an exclusive lock
on devices using both FSSTND and SVr4 methods.

%prep
%setup -q
%patch -p1

%build
export LD_LIBRARY_PATH=$PWD
CFLAGS="%optflags -D_GNU_SOURCE -D_REENTRANT -I$PWD/src -Werror"
LDFLAGS="-L$PWD -l%name"

%define soname lib%name.so.1
gcc $CFLAGS %optflags_shared src/%name.c -shared -Wl,-soname=%soname,-z,defs -o %soname
ln -s %soname lib%name.so

%if_enabled static
gcc $CFLAGS -c src/%name.c -o src/%name-a.o
ar rcu lib%name.a src/%name-a.o
ranlib lib%name.a
%endif

gcc $CFLAGS src/sample.c -o %name $LDFLAGS

cd LockDev
%perl_vendor_build MYEXTLIB="$LDFLAGS"

%install
mkdir -p %buildroot%_libdir/
cp -av lib%name.so* %buildroot%_libdir/

%if_enabled static
cp -av lib%name.a %buildroot%_libdir/
%endif

mkdir -p %buildroot%_sbindir/
cp -av %name %buildroot%_sbindir/

mkdir -p %buildroot%_includedir/
cp -av src/*.h %buildroot%_includedir/

mkdir -p %buildroot%_man3dir/
cp -av docs/%name.3 %buildroot%_man3dir/

cd LockDev
%perl_vendor_install

%files
%attr(2711,root,uucp) %_sbindir/%name

%files -n perl-LockDev
%perl_vendor_archlib/LockDev*
%perl_vendor_autolib/LockDev*

%files -n lib%name
%_libdir/%soname

%files -n lib%name-devel
%_libdir/lib%name.so
%_includedir/*.h
%_man3dir/%name.*

%if_enabled static
%files -n lib%name-devel-static
%_libdir/lib%name.a
%endif

%changelog
