Name: logrotate
Version: 3.9.1
Release: alt2

Summary: Rotates, compresses, and mails system logs
License: GPLv2+
Group: File tools
Url: https://fedorahosted.org/logrotate/

# https://fedorahosted.org/releases/l/o/logrotate/%name-%version.tar.gz
Source: logrotate-%version.tar
Source1: logrotate.cron

Patch1: logrotate-alt-config.patch
Patch2: logrotate-alt-file_type.patch
Patch3: logrotate-alt-taboo.patch
Patch4: logrotate-alt-insecure-permissions.patch

Provides: /etc/logrotate.d

%def_with selinux

BuildRequires: libacl-devel libpopt-devel
%{?_with_selinux:BuildPreReq: libselinux-devel}

%description
The logrotate utility is designed to simplify the administration of log
files on a system which generates a lot of log files.  logrotate allows
for the automatic rotation, compression, removal and mailing of log files.
logrotate can be set to handle a log file daily, weekly, monthly or
when the log file gets to a certain size.  Normally, logrotate runs as
a daily cron job.

%prep
%setup
%patch1 -p1
%patch2 -p1
%patch3 -p1
%patch4 -p1

%build
touch AUTHORS ChangeLog NEWS README
%autoreconf
%configure %{subst_with selinux}
%make_build

%install
%makeinstall_std
mkdir -p %buildroot/etc/logrotate.d

install -pD -m640 examples/logrotate-default %buildroot/etc/logrotate.conf
install -pD -m755 %_sourcedir/logrotate.cron %buildroot/etc/cron.daily/logrotate
install -pD -m644 /dev/null %buildroot%_localstatedir/logrotate/status

%check
make test

%post
if [ ! -s %_localstatedir/logrotate/status -a -s %_localstatedir/logrotate.status ]; then
	mv -f %_localstatedir/logrotate.status %_localstatedir/logrotate/status
fi

%files
%_sbindir/*
%config(noreplace) /etc/cron.daily/logrotate
%config(noreplace) /etc/logrotate.conf
%_mandir/man?/*
%attr(750,root,root) %dir /etc/logrotate.d
%attr(700,root,root) %dir %_localstatedir/logrotate
%attr(644,root,root) %verify(not size md5 mtime) %config(noreplace) %_localstatedir/logrotate/status
%doc CHANGES

%changelog
