# BEGIN SourceDeps(oneline):
BuildRequires(pre): rpm-build-python
BuildRequires: /usr/bin/desktop-file-install
# END SourceDeps(oneline)
%{!?python_sitelib: %global python_sitelib %(%{__python} -c "from distutils.sysconfig import get_python_lib; print get_python_lib()")}

Name:           londonlaw
Version:        0.3.0
Release:        alt1_0.3.pre2
Summary:        Online multiplayer version of a well known detective boardgame
License:        GPLv2
Group:          Games/Other
URL:            http://github.com/anyc/londonlaw
Source0:        http://github.com/anyc/londonlaw/archive/v0.3.0_pre2.tar.gz
Source1:        %{name}.desktop
Source2:        %{name}-server.desktop
BuildRequires:  python-devel python-module-wx ghostscript-utils ghostscript ImageMagick
BuildRequires: /usr/bin/latex texlive-latex-recommended texlive-latex-recommended desktop-file-utils
BuildArch:      noarch
Requires:       python-module-wx python-module-twisted-core python-module-twisted-core-gui python-module-twisted-core-gui-gnome python-module-twisted-core-gui-tk python-module-twisted-core-gui-wx icon-theme-hicolor
Source44: import.info

%description
London Law is an online multiplayer version of a well known detective
boardgame. The game is unusually asymmetric; one player controls the movements
of the criminal Mr. X as he tries to evade the detectives, while another one to
five players control five detectives trying to track him down. Mr. X has an
advantage in access to transportation routes, and his precise location remains
hidden for most of the game. The detectives have only the advantage of superior
numbers, so they must work in concert to limit the criminal's options. London
Law features an attractive map overlaid on high-resolution satellite imagery.


%prep
%setup -q -n %{name}-%{version}_pre2
chmod +x setup.py


%build
./setup.py build
make -C doc manual.pdf


%install
./setup.py install --prefix=%{_prefix} --root=$RPM_BUILD_ROOT
mkdir -p $RPM_BUILD_ROOT%{_datadir}/icons/hicolor/48x48/apps
convert londonlaw/guiclient/images/playericon1.jpg -resize 48x48 \
   $RPM_BUILD_ROOT%{_datadir}/icons/hicolor/48x48/apps/%{name}.png

mkdir -p $RPM_BUILD_ROOT%{_datadir}/applications
desktop-file-install --dir=${RPM_BUILD_ROOT}%{_datadir}/applications %{SOURCE1}
desktop-file-install --dir=${RPM_BUILD_ROOT}%{_datadir}/applications %{SOURCE2}


%files
%doc COPYING doc/ChangeLog doc/TODO doc/*.pdf doc/readme.protocol
%{_bindir}/london-*
%{_datadir}/%{name}
%{python_sitelibdir_noarch}/%{name}
%{python_sitelibdir_noarch}/%{name}-%{version}*-py?.?.egg-info
%{_datadir}/applications/*%{name}*.desktop
%{_datadir}/icons/hicolor/48x48/apps/%{name}.png


%changelog
