%def_disable static
%def_disable debug
%def_enable gtk_doc

Name: loudmouth
Version: 1.5.2
Release: alt1

Summary: Jabber library for C
Group: System/Libraries
License: LGPLv2.1+
Url: https://mcabber.com

#VCS: https://github.com/mcabber/loudmouth.git
Source: %url/files/loudmouth/%name-%version.tar.xz
Patch: %name-1.4.3-alt-certs_location.patch

BuildRequires: libgio-devel >= 2.26 gtk-doc libcheck-devel
BuildRequires: libgnutls-devel >= 1.2.0 libidn-devel libkrb5-devel libasyncns-devel

%description
Loudmouth is a lightweight and easy-to-use C library for programming
with the Jabber protocol. It is designed to be easy to get started with
and yet extensible to let you do anything the Jabber protocol allows.

%package -n lib%name
Summary: Jabber library for C
Group: System/Libraries

%description -n lib%name
Loudmouth is a lightweight and easy-to-use C library for programming
with the Jabber protocol. It is designed to be easy to get started with
and yet extensible to let you do anything the Jabber protocol allows.

%package -n lib%name-devel
Summary: Development files for %name
Group: Development/C
Requires: lib%name = %version-%release

%description -n lib%name-devel
This package contains files needed to develop applications using Loudmouth.
Loudmouth is a lightweight and easy-to-use C library for programming
with the Jabber protocol. It's designed to be easy to get started with
and yet extensible to let you do anything the Jabber protocol allows.

%package -n lib%name-devel-doc
Summary: Development documentation for %name
Group: Development/C
BuildArch: noarch

%description -n lib%name-devel-doc
This package contains development documentation for Loudmouth.
Loudmouth is a lightweight and easy-to-use C library for programming
with the Jabber protocol. It's designed to be easy to get started with
and yet extensible to let you do anything the Jabber protocol allows.

%if_enabled static
%package -n lib%name-devel-static
Summary: Static library for %name
Group: Development/C
Requires: %name-devel = %version-%release

%description -n lib%name-devel-static
This package contains a statically-linked variant of Loudmouth.
Loudmouth is a lightweight and easy-to-use C library for programming
with the Jabber protocol. It's designed to be easy to get started with
and yet extensible to let you do anything the Jabber protocol allows.
%endif	# enabled static

%prep
%setup
%patch -p1 -b .sert_location

%build
%autoreconf
%configure \
	%{?_enable_gtk_doc:--enable-gtk-doc} \
	--with-ssl=gnutls \
	--with-asyncns=yes \
	%{subst_enable debug} \
	%{subst_enable static}

%make_build

%check
%make check

%install
%makeinstall_std

%files -n lib%name
%_libdir/*.so.*
%doc AUTHORS NEWS README

%files -n lib%name-devel
%_libdir/*.so
%_pkgconfigdir/*
%_includedir/*

%files -n lib%name-devel-doc
%_datadir/gtk-doc/html/*

%if_enabled static
%files -n lib%name-devel-static
%_libdir/*.a
%endif # enabled static

%changelog
