Name: ltrace
Version: 0.6.0
Release: alt1

Summary: Tracks runtime library calls from dynamically linked executables
License: GPLv2+
Group: Development/Debuggers
Url: http://ltrace.alioth.debian.org/

# git://anonscm.debian.org/collab-maint/ltrace.git
# git://git.altlinux.org/gears/l/ltrace.git
Source: %name-%version-%release.tar

BuildRequires: libelf-devel

Summary(ru_RU.UTF-8): Трассировщик библиотечных вызовов из динамически скомпонованных приложений

%description
Ltrace is a debugging program which runs a specified command until it
exits.  While the command is executing, ltrace intercepts and records
the dynamic library calls which are called by the executed process and
the signals received by that process.
It can also intercept and print the system calls executed by the program.

The program to be traced need not be recompiled for this, so you can
use it on binaries for which you don't have the source handy.

%description -l ru_RU.UTF-8
Ltrace представляет из себя утилиту отладки, которая запускает указанную
пользователем команду и дожидается её завершения. Пока команда выполняется,
Ltrace перехватывает и выводит все выполняемые процессом вызовы подпрограмм
из динамических библиотек, все системные вызовы и все получаемые сигналы.

Трассируемую программу не требуется перекомпилировать, так что отлаживать
с помощью Ltrace можно даже те приложения, исходные тексты которых недоступны.

%prep
%setup -n %name-%version-%release
bzip -9k ChangeLog

%build
%autoreconf
%configure
%make_build

%install
%makeinstall_std

%files
%_bindir/*
%_mandir/man?/*
%config(noreplace) %_sysconfdir/*
%doc BUGS ChangeLog.bz2 README TODO
%exclude %_docdir/%name

%changelog
