# Original package name Copas
%define oname copas
%define oversion 1.2.1-1
%define rockspec copas-1.2.1-1.rockspec
Name: lua-module-%oname
Version: 1.2.1
Release: alt1_lr1
Summary: Coroutine Oriented Portable Asynchronous Services
License: MIT/X11
Group: Development/Other
Url: http://www.keplerproject.org/copas/
Provides: luarocks(%oname) = %version

BuildArch: noarch

Source: https://github.com/keplerproject/copas/archive/v1_2_1.tar.gz
Source1: https://rocks.moonscript.org/manifests/luarocks/copas-1.2.1-1.rockspec

BuildPreReq: rpm-macros-lua >= 1.1
# Automatically added by buildreq on ...
BuildRequires: liblua5-devel luarocks
BuildRequires: luarocks(luasocket) >= 2.1, luarocks(coxpcall) >= 1.14
Requires: luarocks(luasocket) >= 2.1, luarocks(coxpcall) >= 1.14

%description
      Copas is a dispatcher based on coroutines that can be used by
      TCP/IP servers. It uses LuaSocket as the interface with the
      TCP/IP stack. A server registered with Copas should provide a
      handler for requests and use Copas socket functions to send
      the response. Copas loops through requests and invokes the
      corresponding handlers. For a full implementation of a Copas
      HTTP server you can refer to Xavante as an example.

%prep
%setup -n %oname-1_2_1

%install
%luarocks_make %SOURCE1
%luarocks_move_docs doc

%check
#TODO
exit 0
%lua_path_add_buildroot
for t in %buildroot%luarocks_dbdir/%oname/%oversion/tests/* ; do
  lua $t
done

%files
%lua_modulesdir_noarch/*
%luarocks_dbdir/%oname
%doc README* docs_from_rockstree/*
%exclude %luarocks_dbdir/manifest

%changelog
