# Original package name MobDebug
%define oname mobdebug
%define oversion 0.55-1
%define rockspec mobdebug-0.55-1.rockspec
Name: lua-module-%oname
Version: 0.55
Release: alt1_lr1
Summary: MobDebug is a remote debugger for the Lua programming language
License: MIT/X11
Group: Development/Other
Url: https://github.com/pkulchenko/MobDebug
Provides: luarocks(%oname) = %version

BuildArch: noarch

# git://github.com/pkulchenko/MobDebug.git
Source: MobDebug.tar
Source1: https://rocks.moonscript.org/manifests/luarocks/mobdebug-0.55-1.rockspec

BuildPreReq: rpm-macros-lua >= 1.1
# Automatically added by buildreq on ...
BuildRequires: liblua5-devel luarocks
BuildRequires: luarocks(luasocket) >= 2.0
Requires: luarocks(luasocket) >= 2.0

%description
      MobDebug allows you control the execution of another Lua program remotely,
      set breakpoints, and inspect the current state of the program.

      MobDebug is based on [RemDebug](http://www.keplerproject.org/remdebug/) and
      extends it in several ways:

      * fixed several existing bugs;
      * removed dependency on LuaFileSystem;
      * added new commands: LOAD, RELOAD, OUT, STACK;
      * added support for debugging wxwidgets applications;
      * added ability to pause and abort running applications;
      * added pretty printing and handling of multiple results in EXEC;
      * added stack and local/upvalue value reporting (STACK);
      * added on/off commands to turn debugging on and off (to improve performance);
      * added support for coroutine debugging (see examples/README for details);
      * added support for [Moai](http://getmoai.com/) debugging;
      * added support for Lua 5.2;
      * added support for LuaJIT debugging;
      * added support for cross-platform debugging (with client and server running on different platforms/filesystems);
      * tested integration with [ZeroBrane Studio IDE](http://studio.zerobrane.com/).

%prep
%setup -n MobDebug

%install
%luarocks_make %SOURCE1

%check
%lua_path_add_buildroot
cd %buildroot%luarocks_dbdir/%oname/%oversion/examples
( lua autotest.lua ||: )&
sleep 1
lua loop.lua

%files
%lua_modulesdir_noarch/*
%luarocks_dbdir/%oname
%doc LICENSE* README*
%exclude %luarocks_dbdir/manifest

%changelog
