#
# lxc: linux Container library
#
# (C) Copyright IBM Corp. 2007, 2008
#
# Authors:
# Daniel Lezcano <dlezcano at fr.ibm.com>
#
# This library is free software; you can redistribute it and/or
# modify it under the terms of the GNU Lesser General Public
# License as published by the Free Software Foundation; either
# version 2.1 of the License, or (at your option) any later version.
#
# This library is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
# Lesser General Public License for more details.
#
# You should have received a copy of the GNU Lesser General Public
# License along with this library; if not, write to the Free Software
# Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA
#
# Spec file adapted for ALT Linux.

%global with_systemd 1
%define init_script systemd

Name: lxc
Version: 2.0.4
Release: alt1
Packager: Denis Pynkin <dans@altlinux.org>

URL: https://linuxcontainers.org/
Source: %name-%version.tar
Source1: lxc-net.sysconfig
Patch: %name-%version-%release.patch

Summary: %name : Linux Container
Group: System/Configuration/Other
License: LGPL
Requires: libcap gzip-utils
%ifarch x86_64 %arm
Requires: criu
%endif
Requires: iproute2 bridge-utils dnsmasq
BuildRequires: libcap-devel docbook-utils glibc-kernheaders
BuildRequires: docbook2X xsltproc
BuildRequires: rpm-macros-alternatives
BuildRequires: libcgmanager-devel
BuildRequires: libnih-devel
BuildRequires: libdbus-devel
BuildRequires: libgnutls-devel

# Needed to disable auto requirements from distro templates
%add_findreq_skiplist %_datadir/%name/*

# Do not need to check
%add_findreq_skiplist %_libexecdir/%name/lxc-apparmor-load
%add_findreq_skiplist %_libexecdir/%name/lxc-net

Requires: openssl rsync
BuildRequires: libcap libcap-devel docbook2X graphviz

BuildRequires: systemd-devel

%description
Containers are insulated areas inside a system, which have their own namespace
for filesystem, network, PID, IPC, CPU and memory allocation and which can be
created using the Control Group and Namespace features included in the Linux
kernel.

This package provides the lxc-* tools, which can be used to start a single
daemon in a container, or to boot an entire "containerized" system, and to
manage and debug your containers.

%package	libs
Summary:	Shared library files for %{name}
Group:		System/Configuration/Other
%description	libs
The %{name}-libs package contains libraries for running %{name} applications.

%package	-n python3-module-%name
Summary:	Python 3 bindings to %{name}
Group:		System/Configuration/Other
Obsoletes: %name-python3
Requires: python3
BuildRequires: python3-devel
BuildRequires: rpm-build-python3
%description	-n python3-module-%name
The %{name}-python package contains %{name} bindings for Python 3.

%package devel
Summary: development library for %name
Group: Development/Other

%description devel
The %name-devel package contains header files and library needed for
development of the linux containers.

%prep
%setup
%patch -p1

%build
CFLAGS+=-I%_includedir/linux-default/include/
%autoreconf
%configure -disable-rpath \
    --enable-cgmanager \
    --localstatedir=%_var \
    --with-config-path=%_var/lib/lxc \
    --enable-python \
    --disable-lua \
    --with-distro=altlinux \
    --with-init-script=%{init_script}

%make_build

%install
%make_install DESTDIR=%buildroot install
mkdir -p %buildroot%_localstatedir/%name
mkdir -p %buildroot%_cachedir/%name

%__install -m 0644 %SOURCE1 %buildroot/%_sysconfdir/sysconfig/lxc-net

%files
%defattr(-,root,root)
%{_bindir}/*
%{_mandir}/man1/lxc*
%{_mandir}/man5/lxc*
%{_mandir}/man7/lxc*
%{_mandir}/ja/man1/lxc*
%{_mandir}/ja/man5/lxc*
%{_mandir}/ja/man7/lxc*
%{_mandir}/ko/man1/lxc*
%{_mandir}/ko/man5/lxc*
%{_mandir}/ko/man7/lxc*
%{_datadir}/doc/*
%{_datadir}/lxc/*
%{_sysconfdir}/bash_completion.d/*
%config(noreplace) %{_sysconfdir}/lxc/*
%config(noreplace) %{_sysconfdir}/sysconfig/lxc*
%{_unitdir}/lxc.service
%{_unitdir}/lxc@.service
%{_unitdir}/lxc-net.service

%files libs
%defattr(-,root,root)
%{_sbindir}/*
%{_libdir}/*.so.*
%{_libdir}/%{name}
%{_localstatedir}/*
%{_libexecdir}/%{name}/lxc-apparmor-load
%{_libexecdir}/%{name}/lxc-monitord
%attr(555,root,root) %{_libexecdir}/%{name}/lxc-containers
%attr(555,root,root) %{_libexecdir}/%{name}/lxc-net
%attr(4111,root,root) %{_libexecdir}/%{name}/lxc-user-nic
%{_libexecdir}/%{name}/hooks/*

%files -n python3-module-%name
%defattr(-,root,root)
%{python3_sitelibdir}/_lxc*
%{python3_sitelibdir}/lxc/*

%files devel
%defattr(-,root,root)
%{_includedir}/%{name}/*
%{_libdir}/*.so
%{_libdir}/pkgconfig/*


%changelog
