Name:		lxcfs
Version:	2.0.7
Release:	alt0.M80P.1
Summary:	FUSE filesystem for LXC

Group:		Development/Other
License:	Apache v.2
URL:		https://github.com/lxc/lxcfs

Packager:	Denis Pynkin <dans@altlinux.ru>

Source0:	%name-%version.tar

Requires: libfuse

BuildRequires(pre): libpam-devel
BuildRequires: libfuse-devel
BuildRequires: help2man

%description
FUSE filesystem for LXC, offering the following features:
 - a cgroupfs compatible view for unprivileged containers
 - a set of cgroup-aware files:
   - cpuinfo
   - meminfo
   - stat
   - uptime

%set_pam_name pam_cgfs

%package -n %pam_name
Summary: %summary
Group: System/Base

%description -n %pam_name
%summary
This package provides a Pluggable Authentication Module (PAM) to provide
logged-in users with a set of cgroups which they can administer.
This allows for instance unprivileged containers, and session
management using cgroup process tracking.

%prep
%setup

%build
/bin/bash bootstrap.sh
%configure --disable-static --with-init-script=systemd
%make_build

%install
%makeinstall_std
mkdir -p %buildroot%_localstatedir/%name

%post
[ -d "%_localstatedir/%name" ] || mkdir -p %_localstatedir/%name
%post_service %name

%preun
%preun_service %name

%files
%doc AUTHORS COPYING README.md
%_bindir/*
%_libdir/*.so*
%_man1dir/*
%_unitdir/*
%_datadir/lxc/config/common.conf.d/*
%dir %_datadir/%name
%_datadir/%name/*
%ghost %dir %_localstatedir/%name

%files -n %pam_name
%doc AUTHORS COPYING
%_pam_modules_dir/*

%changelog
