%define upstreamname lxterminal
%define gtkver 2
Name: lxde-lxterminal
Version: 0.3.1
Release: alt0.M80P.1

Summary: Desktop-independent VTE-based terminal emulator for LXDE
License: GPLv2+
Group: Graphical desktop/Other
Url: https://git.lxde.org/gitweb/?p=lxde/lxterminal.git

Packager: LXDE Development Team <lxde at packages.altlinux.org>

Source: %name-%version.tar
Patch: lxterminal-0-1-11-f10-true.patch

BuildPreReq: libgtk+%gtkver-devel docbook-dtds docbook-style-xsl xsltproc libvte-devel intltool desktop-file-utils pkgconfig(glib-2.0) pkgconfig(vte-2.90) pkgconfig(x11) ImageMagick-tools

%description
%summary  without any unnecessary dependency (All instances share the same
process to reduce memory usage)

%prep
%setup -n %name-%version
%patch -p2

%build
%autoreconf
    %configure --enable-man \ 
%if %gtkver==3
               --enable-gtk3
%endif

%make_build

%install
%makeinstall_std
%find_lang %upstreamname
desktop-file-install --dir %buildroot%_desktopdir \
    --remove-category=Utility \
    --add-category=System \
    %buildroot%_desktopdir/lxterminal.desktop

for x in 16 32 48; do
    mkdir -p %buildroot%_iconsdir/hicolor/$x'x'$x/apps
    convert %buildroot%_iconsdir/hicolor/128x128/apps/%upstreamname.png -resize $x'x'$x \
            %buildroot%_iconsdir/hicolor/$x'x'$x/apps/%upstreamname.png
done

%files -f %upstreamname.lang
%doc ChangeLog INSTALL README.md
%_bindir/*
%_desktopdir/*.desktop
%_datadir/%upstreamname
%_man1dir/*
%_iconsdir/hicolor/*/apps/%upstreamname.png

%changelog
