Name: lzip
Version: 1.17
Release: alt1.1

Summary: LZMA file compressor
License: GPL v3+
Group: Archiving/Compression

Url: http://savannah.nongnu.org/projects/lzip/
Source0: http://download.savannah.gnu.org/releases/lzip/%name-%version.tar.gz
Source100: lzip.watch
Packager: Michael Shigorin <mike@altlinux.org>

# Automatically added by buildreq on Sun Sep 20 2009
BuildRequires: gcc-c++

Summary(pl.UTF-8): Kompresor plików oparty na algorytmie LZMA
# explicitly added texinfo for info files
BuildRequires: texinfo

%description
Lzip is a lossless file compressor based on the LZMA
(Lempel-Ziv-Markov chain-Algorithm) algorithm designed by Igor Pavlov.
The high compression of LZMA comes from combining two basic,
well-proven compression ideas: sliding dictionaries (i.e. LZ77/78),
and Markov models (i.e. the thing used by every compression algorithm
that uses a range encoder or similar order-0 entropy coder as its last
stage) with segregation of contexts according to what the bits are
used for.

%description -l pl.UTF-8
lzip to bezstratny kompresor plików oparty na algorytmie LZMA
(Lempel-Ziv-Markov chain-Algorithm) opracowanym przez Igora Pawłowa.
Wysoki stopień kompresji LZMA wywodzi się z połączenia dwóch
podstawowych, dobrze sprawdzonych idei kompresji: przesuwnych
słowników (LZ77/78) i modeli Markowa (używanych przez każdy
algorytm kompresji wykorzystujący w ostatnim stadium kodowanie
zakresów lub podobne kodowanie entropii rzędu 0) z podziałem
kontekstów w zależności od wykorzystania bitów.

%prep
%setup
sed -i 's,@dircategory Data Compression,@dircategory File utilities,' doc/lzip.texi


%build
%configure
make all info

%install
%makeinstall_std install-man

%files
%doc AUTHORS ChangeLog NEWS README
%_bindir/lz*
%_man1dir/lzip.1*
%_infodir/lzip.info*

%changelog
