Name: m4
Version: 1.4.18
Release: alt1

Summary: The GNU macro processor
License: GPLv3+
Group: Development/Other
Url: http://www.gnu.org/software/m4/

# git://git.altlinux.org/gears/m/m4.git
Source: %name-%version-%release.tar

BuildRequires: help2man, gnulib >= 0.1.1209.24b32, makeinfo

%description
A GNU implementation of the traditional UNIX macro processor.  m4 is
useful for writing text files which can be logically parsed, and is
used by many programs as part of their build process.  m4 has built-in
functions for including files, running shell commands, doing arithmetic,
etc.  The autoconf program needs m4 for generating configure scripts,
but not for running configure scripts.

%prep
%setup -n %name-%version-%release

# Build scripts expect to find m4 version in this file.
echo -n %version > .tarball-version

rmdir gnulib
ln -s %_datadir/gnulib .
%define _configure_update_config :

%build
./bootstrap --force
%configure
%make_build MAKEINFOFLAGS=--no-split

%install
%makeinstall_std
install -pD -m644 m4/m4.m4 %buildroot%_datadir/aclocal/m4.m4

%check
%make_build -k check

%files
%_bindir/*
%_infodir/*.info*
%_man1dir/*
%_datadir/aclocal/*
%doc AUTHORS BACKLOG NEWS README THANKS TODO

%changelog
