# Features/TODO:
#	add systemd init support
#       use xz for large archives in /usr/share/mailman/cron/nightly_gzip
Name: mailman
Version: 2.1.22
Release: alt1
Epoch: 5
Packager: Grigory Batalov <bga@altlinux.ru>

%define mm_user %name
%define mm_group %name

%define crontabdir %_sysconfdir/cron.d
%define logrotate %_sysconfdir/logrotate.d
%define ngxconfdir %_sysconfdir/nginx/sites-enabled.d
%define confdir %_sysconfdir/%name
%define _prefix /usr/share/%name
%define _exec_prefix %_libdir/%name
%define _var_prefix %_localstatedir/%name

Summary: Mailing list manager with built in web access
License: GPL
Group: System/Servers
Url: http://www.list.org/

# http://prdownloads.sourceforge.net/%name/%name-%version.tar.tgz
Source: %name-%{version}.tar
# ALT Linux cummulative patch
Patch:  %name-%{version}-%release-alt.patch

PreReq: mktemp, setup, shadow-utils, sendmail-common, vixie-cron
Requires: python, webserver-common, MTA
BuildRequires: python-devel python-module-dns

BuildRequires(pre): python
AutoProv: yes, nopython

BuildRequires(pre): rpm-macros-webserver-common
BuildRequires(pre): rpm-macros-apache
BuildRequires(pre): rpm-macros-apache2

%add_python_req_skip Defaults Mailman mm_config
%define _python_compile_include %_datadir/%name

%description
Mailman, the GNU Mailing List Management System, is a mailing list
management system written mostly in Python. Features:

- Web based list administration for nearly all tasks.  Web based
  subscriptions and user configuration management. A customizable
  "home page" for each mailing list.
- Privacy features such as moderation, open and closed list
  subscription policies, private membership rosters, and sender-based
  filters.
- Automatic web based archiving built-in with support for private
  and public archives, and hooks for external archivers.
- Per-user configuration optional digest delivery for either
  MIME-compliant or RFC 1153 style "plain text" digests.
- Integrated mail/Usenet gateways.
- Integrated auto-replies.
- Majordomo-style email based commands.
- Integrated bounce detection within an extensible framework.
- Integrated spam detection, and MIME-based content filtering.
- An extensible mail delivery pipeline.
- Support for virtual domains.

See the Mailman home site for current status, including new releases
and known problems: %url

%package apache
Group: System/Servers
Summary: Mailman configuration for Apache
BuildArch: noarch
Requires: %name = %version-%release
Requires: apache-base
Obsoletes: %name <= 2.1.21-alt0.1rc2
Conflicts: %name <= 2.1.21-alt0.1rc2

%description apache
Mailman configuration files for Apache

%package apache2
Group: System/Servers
Summary: Mailman configuration for Apache2
BuildArch: noarch
Requires: %name = %version-%release
Requires: apache2-base

%description apache2
Mailman configuration files for Apache2

%package nginx
Group: System/Servers
Summary: Mailman configuration for nginx
BuildArch: noarch
Requires: %name = %version-%release
Requires: nginx

%description nginx
Mailman configuration files for nginx

%package docs
Group: System/Servers
Summary: Mailing list manager with built in web access
BuildArch: noarch

%description docs
Documentation for mailman

%prep
%setup -q -n %name-%{version}
# ALT Linux cummulative patch
%patch -p1

install -pD -m644 alt-linux/mm_cfg.py Mailman/mm_cfg.py.dist.in
install -pD -m644 alt-linux/README.ALT README.ALT

sed -i -e 's,@LOCKFILE@,%_lockdir/%name/master-qrunner,g' cron/crontab.in.in

# Debian patches
# see http://packages.qa.debian.org/m/mailman.html
for patch in \
10_wrapper_uid.patch \
51_nocompile.pyc.patch \
52_check_perms_lstat.patch \
53_disable_addons.patch \
63_update_default_server_language.patch \
66_donot_let_cache_html_pages.patch \
79_archiver_slash.patch \
90_gettext_errors.patch
do
	echo "Patch ($patch):"
	patch -s -p1 < debian/patches/$patch
done

touch src/*.c

%build
%autoreconf
%configure \
	--with-var-prefix=%_var_prefix \
	--with-config-dir=%confdir \
	--with-lock-dir=%_lockdir/%name \
	--with-log-dir=%_logdir/%name \
	--with-pid-dir=%_var/run/%name \
	--with-queue-dir=%_spooldir/%name \
	--with-python=%__python \
	--with-mail-groupfile=%confdir/mail.groups \
	--with-cgi-groupfile=%confdir/cgi.groups \
	--with-mailhost=localhost.localdomain \
	--with-urlhost=localhost.localdomain \
	--without-permcheck

# rebuild mailman.pot
%make -C messages potfile

%make_build OPT="$RPM_OPT_FLAGS"

%install
find bin -type f -print0 |
	xargs -r0 grep -Zl '%__python$' |
	xargs -r0 subst 's|%__python$|%__python -O|g'

%make_install doinstall \
	DESTDIR=%buildroot \
	prefix=%prefix \
	exec_prefix=%_exec_prefix \
	var_prefix=%_var_prefix

chmod -R go-w %buildroot{%prefix,%_exec_prefix}
find %buildroot{%prefix,%_exec_prefix} -type d -print0 |
	xargs -r0 chmod a-s,o-r
chmod a-s,go-r %buildroot%_var_prefix

# Create directories we'll use for log and spool files. Create links
install -d -m3771 %buildroot%_logdir/%name
install -d -m2770 %buildroot%_spooldir/%name
install -d -m2771 %buildroot%_spooldir/%name/{archive,bounces,commands,in,news,out,qfiles,retry,shunt,virgin}

ln -s ../../log/%name %buildroot%_var_prefix/logs
ln -s ../../spool/%name %buildroot%_var_prefix/qfiles

# Copy an icons into the web server's icons directory.
mkdir -p %buildroot%webserver_iconsdir
cp -a %buildroot%prefix/icons/* %buildroot%webserver_iconsdir

# Install a logrotate control file.
install -pD -m644 alt-linux/%name.logrotate \
	%buildroot%logrotate/%name

# Install the httpd configuration file.
install -pD -m644 /dev/null %buildroot%apache_modconfdir/%name.conf
sed -e 's|@CODEDIR@|%_exec_prefix|g;s|@DATADIR@|%_var_prefix|g' \
	alt-linux/%name-httpd.conf > %buildroot%apache_modconfdir/%name.conf

# Install the httpd2 configuration file.
install -d %buildroot%apache2_mods_start
install -d %buildroot%apache2_sites_available
install -d %buildroot%apache2_sites_start
install -d %buildroot%apache2_ports_start
install -p -m644 alt-linux/apache2.mods-start %buildroot%apache2_mods_start/%name.conf
install -p -m644 alt-linux/apache2.sites-start %buildroot%apache2_sites_start/%name.conf
install -p -m644 alt-linux/apache2.ports-start %buildroot%apache2_ports_start/%name.conf
sed -e 's|@CODEDIR@|%_exec_prefix|g;s|@DATADIR@|%_var_prefix|g' \
	alt-linux/apache2.sites-available > %buildroot%apache2_sites_available/%name.conf

# Install the nginx configuration file.
install -pD -m644 /dev/null %buildroot%ngxconfdir/%name.conf
sed -e 's|@CODEDIR@|%_exec_prefix|g;s|@DATADIR@|%_var_prefix|g' \
	alt-linux/%name-nginx.conf > %buildroot%ngxconfdir/%name.conf

# Install crontab file
install -pD -m644 cron/crontab.in %buildroot%crontabdir/%name

# Install init script
install -pD -m755 misc/mailman %buildroot%_initdir/%name

# Install config files for postfix
install -pD -m644 alt-linux/mm_config.py %buildroot%confdir/mm_config.py
touch %buildroot%confdir/{aliases,virtual-mailman}
touch %buildroot%confdir/{aliases,virtual-mailman}.cdb

cat <<EOF > %buildroot%confdir/mail.groups
mail
postman
%mm_group
EOF

cat <<EOF > %buildroot%confdir/cgi.groups
apache
apache2
_spawn_fcgi
EOF

# Install man pages
install -m755 -pd %buildroot%_man8dir
install -m644 debian/manpages/*.8 %buildroot%_man8dir/

# Install lockdir and piddir
install -m755 -pd %buildroot%_lockdir/%name
install -m755 -pd %buildroot%_var/run/%name

# Remove unused files
rm -f %buildroot%confdir/sitelist.cfg
rm -rf %buildroot%_datadir/%name/tests

%pre
/usr/sbin/groupadd -rf %mm_group ||:
/usr/sbin/useradd -M -r -s /dev/null -c "GNU Mailing List Manager" \
	-d %_var_prefix -g %mm_group %mm_user &>/dev/null ||:

%post
%post_service mailman
# Fix file permissions
if [ -f %_localstatedir/%name/data/last_mailman_version ]; then
	chown %mm_user:%mm_group %_localstatedir/%name/data/last_mailman_version ||:
	chmod 644 %_localstatedir/%name/data/last_mailman_version ||:
	echo "Update mailman's database:"
	%_prefix/bin/update ||:
else
	%_prefix/bin/update &> /dev/null ||:
fi

%post apache
%post_apacheconf

%post apache2
%apache2_sbindir/a2chkconfig
%post_apache2conf

%postun apache
%postun_apacheconf

%postun apache2
%apache2_sbindir/a2chkconfig
%postun_apache2conf

%preun
%preun_service mailman

%triggerin -- postfix
# Generate aliases
%_prefix/bin/genaliases

%triggerpostun -- mailman = 5:2.1.12-alt2.1.1
echo "WARNING! Upgrading from legacy version!"
echo "Please check README.ALT for possible"
echo "problems and solutions."

%triggerun -- mailman < 5:2.1.9-alt2
if [ $1 != 0 ]; then
# Move old configs and passwords and change group
	for file in aliases virtual-mailman mm_config.py; do
		if [ -f %_localstatedir/%name/etc/$file ]; then
			mv %_localstatedir/%name/etc/$file %confdir/$file ||:
			chgrp %mm_group %confdir/$file ||:
		fi
	done
	for file in adm.pw creator.pw; do
		if [ -f %_localstatedir/%name/data/$file ]; then
			mv %_localstatedir/%name/data/$file %confdir/$file ||:
			chgrp %mm_group %confdir/$file ||:
		fi
	done
# Change paths in Postfix config
	if [ -f %_sysconfdir/postfix/main.cf ]; then
		sed  -i -e 's,%_localstatedir/%name/etc/aliases,%confdir/aliases,g' \
			-e 's,%_localstatedir/%name/etc/virtual-mailman,%confdir/virtual-mailman,g' \
			%_sysconfdir/postfix/main.cf ||:
	fi
# Move lockfiles and pidfile
	for file in %_localstatedir/%name/locks/*; do
		[ -f $file ] && mv $file %_lockdir/%name/ ||:
	done
	[ -f %_localstatedir/%name/data/master-qrunner.pid ] && \
		mv -f %_localstatedir/%name/data/master-qrunner.pid %_var/run/%name/ ||:
fi
# Restart mailman again with configs at the new place
%post_service mailman

%files
%config(noreplace) %logrotate/%name
%config(noreplace) %crontabdir/%name
%attr(0755,root,root) %_initdir/%name
%webserver_iconsdir/*
%dir %prefix
%prefix/bin
%prefix/cron
%prefix/Mailman
%prefix/messages
%prefix/pythonlib
%prefix/scripts
%prefix/templates
%doc ACKNOWLEDGMENTS BUGS FAQ INSTALL NEWS README* STYLEGUIDE.txt TODO UPGRADING
%doc misc/sitelist.cfg tests
%doc %_man8dir/*
%dir %attr(0770,root,%mm_group) %_lockdir/%name
%dir %attr(0770,root,%mm_group) %_var/run/%name

%defattr(-,root,%mm_group,-)
%_exec_prefix
%dir %attr(0751,root,%mm_group) %_var_prefix
%dir %_var_prefix/archives
%dir %_var_prefix/archives/*
%dir %_var_prefix/spam
%dir %_var_prefix/lists
%dir %_var_prefix/data
%dir %attr(2771,root,%mm_group) %confdir
%config(noreplace) %attr(0664,root,%mm_group) %confdir/mm_config.*
%config(noreplace) %attr(0664,root,%mm_group) %confdir/aliases
%config(noreplace) %attr(0664,root,%mm_group) %confdir/virtual-mailman
%config(noreplace) %attr(0664,root,%mm_group) %confdir/*groups
%ghost %attr(644,root,root) %config(missingok) %verify(not md5 mtime size) %confdir/*.cdb
%_var_prefix/logs
%_var_prefix/qfiles
%_logdir/%name
%dir %_spooldir/%name
%dir %_spooldir/%name/*

%files apache
%config(noreplace) %apache_modconfdir/%name.conf

%files apache2
%config(noreplace) %apache2_mods_start/%name.conf
%config(noreplace) %apache2_sites_available/%name.conf
%config(noreplace) %apache2_sites_start/%name.conf
%config(noreplace) %apache2_ports_start/%name.conf

%files nginx
%config(noreplace) %ngxconfdir/%name.conf

%files docs
%doc doc

%changelog
