%define _unpackaged_files_terminate_build 1

# see http://lists.altlinux.org/pipermail/devel/2012-February/193243.html
%def_disable python

# see http://bugzilla.altlinux.org/31466
%def_disable guile

# https://lists.altlinux.org/pipermail/devel/2018-August/205163.html
%def_enable mh

%define use_chrpath 0
%define snapshot    1

Name: mailutils

%define baseversion 3.10

%if %snapshot
%define snapshotdate 20200913
Version: %baseversion
Release: alt0.%snapshotdate.1
%define srcdir %name-%snapshotdate
%else
Version: %baseversion
Release: alt1
%define srcdir %name-%version
%endif

Summary: GNU Mailutils

License: GPL-3.0-or-later

%if %snapshot
Source0:        %name-%version-%snapshotdate.tar.gz
%else
Source0:        %name-%version.tar.gz
%endif

URL: http://www.gnu.org/software/%{name}/%{name}.html
Group: Networking/Mail

Patch1: mailutils-2.0.90-pkg-config-hack.diff

# errata patches
#Patch10:

Conflicts: mailx

Provides: /bin/mail

%add_findreq_skiplist */usr/bin/guimb

Requires: libmailutils = %{version}-%{release}
Requires: libreadline

# Automatically added by buildreq on Mon Feb 06 2012
# optimized out: emacs-X11 emacs-base emacs-cedet-speedbar emacs-common fontconfig guile18 libX11-locales libgdk-pixbuf libgmp-devel libgpg-error libltdl7-devel libncurses-devel libstdc++-devel libtinfo-devel python-base python-modules
BuildRequires: bzlib-devel flex gcc-c++ glibc-devel libdb4-devel libgcrypt-devel libgdbm-devel libgnutls-devel libldap-devel libpam-devel libreadline-devel libtokyocabinet-devel python-devel zlib-devel

BuildRequires: /dev/pts
BuildRequires: makeinfo

BuildRequires: libltdl7-devel
BuildRequires: perl-podlators

%if_enabled mh
BuildRequires: emacs-X11
%endif

%if %use_chrpath
BuildRequires: chrpath
%endif

%description
GNU Mailutils is a rich and powerful protocol-independent mail
framework. It contains a series of useful mail libraries, clients,
and servers. These are the primary mail utilities for the GNU system.
The central library is capable of handling electronic mail in various
mailbox formats and protocols, both local and remote.  Specifically,
this project contains a POP3 server, an IMAP4 server, and a Sieve mail
filter. It also provides a POSIX `mailx' client, and a collection of
other handy tools.

%package -n libmailutils
Summary: GNU Mailutils: mailbox access library.
License: LGPL-3.0-or-later
Group: System/Libraries
Obsoletes: libmailutils-sieve

%description -n libmailutils
The runtime library libmailbox contains various mailbox access
routines and support for a number of mailbox types, such as mbox,
maildir, mh, POP3, and IMAP4. It also supports MIME message
handling, and sending mail via SMTP and /sbin/sendmail.

%package -n libmailutils-devel
Summary: GNU Mailutils: mailbox access development.
License: LGPL-3.0-or-later
Requires: libmailutils
Group: Development/Other

%description -n libmailutils-devel
GNU Mailutils: mailbox access development.

%package -n libmailutils-devel-static
Summary: GNU Mailutils: mailbox access static library development.
License: LGPL-3.0-or-later
Requires: libmailutils-devel
Group: Development/Other

%description -n libmailutils-devel-static
GNU Mailutils: mailbox access static library development.

%package doc
Summary: GNU Mailutils: documentation.
License: GFDL-1.2
Group: Development/Documentation
BuildArch: noarch

%description doc
API reference for libmailbox and user documentation for the rest of
the GNU Mailutils.

%package pop3d
Summary: GNU Mailutils: POP3 daemon.
License: GPL-3.0-or-later
Requires: libmailutils = %{version}-%{release}
Conflicts: courier-imap
Group: System/Servers

%description pop3d
The GNU POP3 daemon. Uses libmailbox to support different styles of
mailboxes.

%package imap4d
Summary: GNU Mailutils: IMAP4 daemon.
License: GPL-3.0-or-later
Requires: libmailutils = %{version}-%{release}
Group: System/Servers

%description imap4d
The GNU IMAP4 daemon. Uses libmailbox to support different styles of
mailboxes.

%package sieve
Summary: GNU Mailutils: mail filtering language Sieve.
License: LGPL-3.0-or-later
Requires: libmailutils = %{version}-%{release}
Group: Networking/Mail

%description sieve
GNU implementation of the mail filtering language Sieve, described in
RFC 3028 and RFC 3431. This packages contains also the Sieve interpreter
and Sieve to Scheme translator and filter.

%package comsatd
Summary: GNU Mailutils: Comsat daemon.
License: GPL-3.0-or-later
Requires: libmailutils = %{version}-%{release}
Group: System/Servers

%description comsatd
GNU Comsatd is the server which receives reports of incoming mail and
notifies users, wishing to get this service. It can be started either
from `inetd.conf' or as a standalone daemon.

%package delivery-agents
Summary: GNU Mailutils: General-purpose Mail Delivery Agents.
License: GPL-3.0-or-later
Requires: libmailutils = %{version}-%{release}
Group: Networking/Mail
Provides: mailutils-maidag = %{version}-%{release}
Obsoletes: mailutils-maidag < %{version}-%{release}

%description delivery-agents
This subpackage replaced old maidag subpackage and contais three
utilites: mda, lmtpd and putmail

%if_enabled guile
%package guile
Summary: GNU Mailutils: Guile bindings.
License: GPL-3.0-or-later
Requires: libmailutils = %{version}-%{release}
Requires: guile >= 1.8
Group: System/Libraries

BuildRequires: guile18-devel

%description guile
Guile bindings for GNU Mailutils.
%endif

%package locales
Summary: National Language files for mailutils
License: GPL-3.0-or-later
Group: Networking/Mail
BuildArch: noarch

%description locales
National Language files for mailutils

%if_enabled mh
%package mh
Summary: GNU Mailutils: The Message Handling System.
License: GPL-3.0-or-later
Requires: libmailutils = %{version}-%{release}
Requires: emacs-base
Group: Networking/Mail

%description mh
The GNU MH (Message Handling System).
%endif

%if_enabled python
%package -n libmailutils-python
Summary: GNU Mailutils: libraries for integration with Python
License: LGPL-3.0-or-later
Requires: libmailutils = %{version}-%{release}
Group: System/Libraries

%description -n libmailutils-python
The libraries for integration with Python

%package -n python-module-mailutils
Summary: A Python interface to Mailutils framework
License: GPL-3.0-or-later
Group: Networking/Mail
BuildArch: noarch
Requires: python-module-mailutils-api = %version-%release

%description -n python-module-mailutils
This package contains Python bindings for GNU Mailutils.

%package -n python-module-mailutils-api
Summary: A Python interface to Mailutils framework, arch specific part
License: GPL-3.0-or-later
Group: Networking/Mail
Requires: libmailutils = %version-%release
Conflicts: python-module-mailutils < %version-%release

%description -n python-module-mailutils-api
This package contains architecture specific part of the
python-module-mailutils.
%endif

%prep
%if %snapshot
%setup -q -n %name-%version-%snapshotdate
%else
%setup -q
%endif

#patch1 -p0

# errata patches
#patch10 -p1

gzip ChangeLog

# https://lists.altlinux.org/pipermail/devel/2020-September/212028.html
%ifnarch %ix86 x86_64
sed -i "s|m4_include..strin.at..|dnl m4_include([strin.at])|"   libmailutils/tests/testsuite.at
sed -i "s|m4_include..strout.at..|dnl m4_include([strout.at])|" libmailutils/tests/testsuite.at
sed -i "s|m4_include..strerr.at..|dnl m4_include([strerr.at])|" libmailutils/tests/testsuite.at
%endif

# some includes for info-documentation are absent in 2.9.91
pushd doc/texinfo
for file in addr http mailcap numaddr sfrom url-parse
do
 [ -f $file.inc ] || touch $file.inc
done
popd

# see http://bugzilla.altlinux.org/31449
sed "s/^@hashchar{}/#/" -i doc/texinfo/programs.texi

%build

%if ! %snapshot
%if ! %use_chrpath
# fixed RPATH issue (3.1.1 tarball created with wrong libtool)
%autoreconf
cp -f po/Makefile.in.in~ po/Makefile.in.in
%endif
%endif

%set_verify_elf_method unresolved=relaxed
#undefine __libtoolize

%add_optflags "-llber"

%configure \
    --disable-rpath \
    --enable-ipv6 \
    %if_enabled mh
    --with-mh-bindir=%_libexecdir/mu-mh \
    %else
    --disable-mh \
    %endif
    %if_enabled guile
    --with-guile-site-dir=%_datadir/guile/site \
    %else
    --without-guile \
    %endif
    %{!?_enable_python: --disable-python} \
    #

./config.status | sed -n '/[*]\+/,/[*]\+/p' > README-build-config

# SMP-incompatible build.
%make V=1

%check

NAME=`whoami`
sed -i "s|SENDER: gray@nonexistent.net|SENDER: $NAME@nonexistent.net|" \
  $RPM_BUILD_DIR/%name-%version-%snapshotdate/sieve/tests/moderator.at

#make check MH=/dev/null || { cat mh/tests/testsuite.log; exit 1; }
%make check

%install

%makeinstall_std

install -d $RPM_BUILD_ROOT/bin
ln -s ..%_bindir/mail "$RPM_BUILD_ROOT/bin/mail"
pushd $RPM_BUILD_ROOT%_bindir
    ln -s mail Mail
    ln -s mail mailx
popd

%if_enabled guile
pushd $RPM_BUILD_ROOT%_libdir
    NAME1=`ls libguile-mailutils*.so`
    NAME2=`find libmu_scm.so.* -type f`
    ln -sf $NAME2 $NAME1
popd
%endif

rm -f $RPM_BUILD_ROOT%python_sitelibdir/mailutils/c_api.a
rm -f $RPM_BUILD_ROOT%python_sitelibdir/mailutils/c_api.la

%if %use_chrpath
find $RPM_BUILD_ROOT -type f | while read f; do
    COUNT=`file $f | grep ELF | wc -l`
    if [ $[ $COUNT > 0 ] == 1 ]; then
       chrpath -d $f
    fi
done
%endif

%find_lang %name

%files -n mailutils
%doc AUTHORS THANKS COPYING* NEWS README* TODO ChangeLog.gz

%_bindir/mailutils
%_bindir/dotlock
%_bindir/frm
%_bindir/from
%_bindir/mail
%_bindir/mailx
%_bindir/Mail
/bin/mail
%_bindir/popauth
%_bindir/messages
%_bindir/mimeview
%_bindir/movemail
%_bindir/readmsg
%_bindir/decodemail
%_mandir/*/mail*

%dir %_libexecdir/mailutils
%_libexecdir/mailutils/mailutils-*

%files -n libmailutils

%dir %_libdir/mailutils
%_libdir/mailutils/moderator.so
%_libdir/mailutils/vacation.so
%_libdir/mailutils/pipe.so
%_libdir/mailutils/list.so
%_libdir/mailutils/numaddr.so
%_libdir/mailutils/spamd.so
%_libdir/mailutils/timestamp.so
%_libdir/mailutils/editheader.so

%_libdir/libmailutils.so.*
%_libdir/libmuaux.so.*

%exclude %_libdir/libmu_*.so
%_libdir/libmu_*.so.*

%if_enabled python
%exclude %_libdir/libmu_py.so.*
%endif

%files -n libmailutils-devel
%_includedir/*
%_bindir/mailutils-config
%_datadir/aclocal/mailutils.m4
#_libdir/libmu_argp.a
%_libdir/libmailutils.so
%_libdir/libmuaux.so
%_libdir/libmu_*.so

%files -n libmailutils-devel-static
%_libdir/libmailutils.*a
%_libdir/mailutils/moderator.*a
%_libdir/mailutils/vacation.*a
%_libdir/mailutils/pipe.*a
#exclude #_libdir/libmu_argp.a
%_libdir/libmu*.*a
%_libdir/mailutils/list.*a
%_libdir/mailutils/numaddr.*a
%_libdir/mailutils/spamd.*a
%_libdir/mailutils/timestamp.*a
%_libdir/mailutils/editheader.*a

%files doc
%_infodir/*

%files pop3d
%_sbindir/pop3d
%_mandir/*/pop*

%files imap4d
%_sbindir/imap4d
%_mandir/*/imap4d*

%files comsatd
%_sbindir/comsatd

%files delivery-agents
%_sbindir/mda
%_sbindir/lmtpd
%_bindir/putmail

%files sieve
%_bindir/sieve

%if_enabled guile
%files guile
%dir %_datadir/guile/site/mailutils
%dir %_datadir/guile/site/mailutils/sieve-modules
%_bindir/guimb
%_bindir/sieve2scm
%_datadir/guile/site/mailutils/*.scm
%_datadir/guile/site/mailutils/*.txt
%_datadir/guile/site/mailutils/sieve-modules/*.scm
%_libdir/libguile-mailutils*.so
%endif

%files locales -f %name.lang

%if_enabled mh
%files mh
%dir %_libexecdir/mu-mh
%dir %_datadir/mailutils
%dir %_datadir/mailutils/mh
%_libexecdir/mu-mh/*
%_datadir/mailutils/mh/*
%_datadir/emacs/site-lisp/*
%endif

%if_enabled python
%files -n libmailutils-python
%_libdir/libmu_py.so.*

%files -n python-module-mailutils
%dir %python_sitelibdir_noarch/mailutils/
%python_sitelibdir_noarch/mailutils/*.py*

%files -n python-module-mailutils-api
%dir %python_sitelibdir/mailutils/
%python_sitelibdir/mailutils/*.so
%endif

%changelog
