Name: make-initrd
Version: 0.8.16
Release: alt3

Summary: Creates an initramfs image
License: GPL3
Group: System/Base

Packager: Alexey Gladkov <legion@altlinux.ru>

BuildRequires: help2man libkmod-devel makeinfo

Provides: mkinitrd = 2:%version-%release

Requires: ash libshell make sed module-init-tools coreutils findutils grep glibc-utils

# depinfo
Requires: libkmod >= 8-alt1

# ipconfig -q: kinit-utils-1.5.15-alt3
# run-init -e: kinit-utils-1.5.17-alt2
# ipconfig -D: kinit-utils-1.5.25-alt2
Requires: kinit-utils >= 1.5.25-alt2

# Move /dev from initrd to the real system.
# 167: udevadm info --run
Requires: udev >= 167-alt1

# installkernel
Requires: bootloader-utils >= 0.4.10-alt1

# blkid
Requires: util-linux >= 2.17.2-alt1

# This avoids getting a dependency on sh from "#!/bin/sh".
#AutoReq: yes, nopam, noperl, nopython, noshell, notcl
AutoReq: noshell, noshebang

Source0: %name-%version.tar

%description
make-initrd is a new, uevent-driven initramfs infrastructure based around udev.

%package devmapper
Summary: device-mapper module for %name
Group: System/Base
Requires: %name = %version-%release
Requires: dmsetup >= 1.02.44-alt3
AutoReq: noshell, noshebang

%description devmapper
device-mapper module for %name

%package lvm
Summary: LVM module for %name
Group: System/Base
Requires: %name = %version-%release
Requires: %name-devmapper = %version-%release
Requires: lvm2
AutoReq: noshell, noshebang

%description lvm
LVM module for %name

%package luks
Summary: LUKS module for %name
Group: System/Base
Requires: %name = %version-%release
Requires: %name-devmapper = %version-%release
Requires: cryptsetup
AutoReq: noshell, noshebang

%description luks
LUKS module for %name

%package nfs
Summary: NFS module for %name
Group: System/Base
AutoReq: noshell, noshebang

%description nfs
NFS module for %name

%package multipath
Summary: multipath module for %name
Group: System/Base
Requires: %name = %version-%release
Requires: %name-devmapper = %version-%release
Requires: multipath-tools > 0.6.1-alt1
AutoReq: noshell, noshebang

%description multipath
Multipath module for %name

%package plymouth
Summary: plymouth module for %name
Group: System/Base
Requires: %name = %version-%release
Requires: plymouth
AutoReq: noshell, noshebang

%description plymouth
plymouth module for %name

%package mdadm
Summary: mdadm module for %name
Group: System/Base
Requires: %name = %version-%release
Requires: mdadm
AutoReq: noshell, noshebang

%description mdadm
Mdadm module for %name

%package ucode
Summary: CPU microcode module for %name
Group: System/Base
Requires: %name = %version-%release
Requires: iucode_tool, firmware-intel-ucode, linux-firmware
Requires: cpio
AutoReq: noshell, noshebang

%description ucode
CPU microcode autoloading module for %name

%prep
%setup -q

%build
%make_build

%install
%make_install DESTDIR=%buildroot install

%triggerin -- %name < 0.8.1-alt1
c="%_sysconfdir/initrd.mk"
if [ -s "$c" ] && ! grep -qs '^AUTODETECT[[:space:]]*=[[:space:]]*all[[:space:]]*' "$c"; then
	printf -- 'make-initrd: Migrating to new autodetect scheme ...\n' >&2
	sed -i -e 's/^\(AUTODETECT[[:space:]]*=.*\)$/# \1\nAUTODETECT = all/' "$c"
fi

%files
%dir %_sysconfdir/initrd.mk.d
%config(noreplace) %_sysconfdir/initrd.mk.d/*.mk.example
%config(noreplace) %_sysconfdir/initrd.mk
%_bindir/*
%_sbindir/*
%_datadir/%name
%_man1dir/*
%_infodir/*
%exclude %_datadir/%name/features/devmapper
%exclude %_datadir/%name/features/lvm
%exclude %_datadir/%name/features/luks
%exclude %_datadir/%name/features/nfsroot
%exclude %_datadir/%name/features/multipath
%exclude %_datadir/%name/features/plymouth
%exclude %_datadir/%name/features/mdadm
%exclude %_datadir/%name/features/ucode
%doc README.ru

%files devmapper
%_datadir/%name/features/devmapper

%files lvm
%_datadir/%name/features/lvm

%files luks
%_datadir/%name/features/luks

%files nfs
%_datadir/%name/features/nfsroot

%files multipath
%_datadir/%name/features/multipath

%files plymouth
%_datadir/%name/features/plymouth

%files mdadm
%_datadir/%name/features/mdadm

%files ucode
%_datadir/%name/features/ucode

%changelog
