%global cache /var/cache/man

Summary: Tools for searching and reading man pages
Name: man-db
Version: 2.7.6.1
Release: alt4.1
# GPLv2+ .. man-db
# GPLv3+ .. gnulib
License: GPLv2+ and GPLv3+
Group: System/Base
URL: http://www.nongnu.org/man-db/

Packager: Alexey Gladkov <legion@altlinux.ru>

Source0: %name-%version.tar
Source1: man-db.crondaily
Source2: man-db.sysconfig
Source3: man-db.filetrigger

Patch0: man-db-2.7.6.1-change-owner-of-man-cache.patch

# http://lists.nongnu.org/archive/html/man-db-devel/2017-01/msg00013.html
Patch1: man-db-2.7.6.1-fix-override-dir-handling.patch

Obsoletes: man < 2.0
Obsoletes: man-whatis < 2.0
Provides: man-whatis = %version

Provides: man = %version
Provides: man-pages-reader = %version

# previous versions of the package contain the files: apropos.1, man.1, whatis.1
Conflicts: man-pages-ru-extra < 0.1-alt5

Requires: coreutils, grep, groff-base, gzip, less

BuildRequires: gnu-config
BuildRequires: gdbm-devel
BuildRequires: gettext
BuildRequires: groff-base groff-ps
BuildRequires: less
BuildRequires: libpipeline-devel
BuildRequires: zlib-devel
BuildRequires: flex
BuildRequires: po4a
BuildRequires: perl
BuildRequires: xz

%description
The man-db package includes five tools for browsing man-pages:
man, whatis, apropos, manpath and lexgrog. man formats and displays
manual pages. whatis searches the manual page names. apropos searches the
manual page names and descriptions. manpath determines search path
for manual pages. lexgrog directly reads header information in
manual pages.

%package cron
Summary: Periodic update of man-db cache
Group: System/Base

Requires: %name = %version-%release
Requires: crontabs

BuildArch: noarch

%description cron
This package provides periodic update of man-db cache.

%prep
%setup

%patch0 -p1
%patch1 -p1

%build
%configure \
    --with-sections="1 1p 8 2 3 3p 4 5 6 7 9 0p n l p o 1x 2x 3x 4x 5x 6x 7x 8x" \
    --disable-setuid \
    --enable-cache-owner=root \
    --with-browser=elinks \
    --with-lzip=lzip \
    --with-override-dir=overrides

%make CC="%__cc %optflags" %{?_smp_mflags} V=1

%check
%make check

%install
%make install \
	INSTALL='install -p' \
	DESTDIR=%buildroot \
	prefix=%_prefix

# move the documentation to the relevant place
mv %buildroot%_datadir/doc/man-db/* ./

# remove zsoelim man page - part of groff package
rm %buildroot%_man1dir/zsoelim.1

# remove libtool archives
rm %buildroot%_libdir/man-db/*.la

# install cache directory
install -d -m 0755  %buildroot/%cache

# install cron script for man-db creation/update
mkdir -p %buildroot%_sysconfdir/cron.daily
install -D -p -m 0755 %SOURCE1 %buildroot%_sysconfdir/cron.daily/man-db.cron

# config for cron script
mkdir -p %buildroot%_sysconfdir/sysconfig
install -D -p -m 0644 %SOURCE2 %buildroot%_sysconfdir/sysconfig/man-db

# install filetrigger
mkdir -p %buildroot%_rpmlibdir
install -D -p -m 0755 %SOURCE3 %buildroot%_rpmlibdir/man-db.filetrigger

# config for tmpfiles.d
install -D -p -m 0644 init/systemd/man-db.conf %buildroot/usr/lib/tmpfiles.d/.

%find_lang %name
%find_lang %name-gnulib

cat %name.lang %name-gnulib.lang > %name.files

# clear the old cache
%post
%__rm -rf -- %cache/*

%files -f %name.files
%doc README NEWS docs/COPYING
%config(noreplace) %_sysconfdir/man_db.conf
%config(noreplace) /usr/lib/tmpfiles.d/man-db.conf
%_sbindir/*
%_bindir/*
%_libdir/man-db
%_libexecdir/man-db
%_rpmlibdir/man-db.filetrigger
%attr(2755,root,man) %verify(not mtime) %dir %cache
# documentation and translation
%_man1dir/*.1*
%_man5dir/*.5*
%_man8dir/*.8*
%lang(da)    %_datadir/man/da/man*/*
%lang(de)    %_datadir/man/de/man*/*
%lang(es)    %_datadir/man/es/man*/*
%lang(fr)    %_datadir/man/fr/man*/*
%lang(id)    %_datadir/man/id/man*/*
%lang(it)    %_datadir/man/it/man*/*
%lang(ja)    %_datadir/man/ja/man*/*
%lang(nl)    %_datadir/man/nl/man*/*
%lang(pl)    %_datadir/man/pl/man*/*
%lang(ru)    %_datadir/man/ru/man*/*
%lang(sv)    %_datadir/man/sv/man*/*
%lang(zh_CN) %_datadir/man/zh_CN/man*/*

%files cron
%config(noreplace) %_sysconfdir/cron.daily/man-db.cron
%config(noreplace) %_sysconfdir/sysconfig/man-db

%changelog
