Group: System/Libraries
# BEGIN SourceDeps(oneline):
BuildRequires(pre): rpm-build-python
BuildRequires: /usr/bin/glib-gettextize pkgconfig(gio-2.0) pkgconfig(glib-2.0)
# END SourceDeps(oneline)

%define _libexecdir %_prefix/libexec
Name:           mate-menus
Version:        1.12.0
Release:        alt3.M80P.2
Summary:        Displays menus for MATE Desktop
License:        GPLv2+ and LGPLv2+
URL:            http://mate-desktop.org
Source0:        http://pub.mate-desktop.org/releases/1.12/%{name}-%{version}.tar.xz

Patch0:         mate-menus_add-categories.patch

BuildRequires:  chrpath
BuildRequires:  gobject-introspection-devel
BuildRequires:  mate-common
BuildRequires:  python-devel

Requires: libmate-menus = %{version}-%{release}
Obsoletes: altlinux-freedesktop-menu-mate < %version-%release
Provides: altlinux-freedesktop-menu-mate = %version-%release

# we don't want to provide private python extension libs
%{echo 


}
Source44: import.info
%add_findprov_skiplist %{python_sitelibdir}/.*\.so$
Patch33: gnome-menus-2.14-alt-add-config-dir.patch
Patch34: gnome-menus-alt-applications-menu-no-legacy-kde.patch
Patch1: mate-menus-1.12.0-alt-xmintfullname-genericname.patch

%description
Displays menus for MATE Desktop

%package -n libmate-menus
Group: System/Libraries
Summary: Shared libraries for mate-menus
#Requires:	%{name}%{?_isa} = %{version}-%{release}

%description -n libmate-menus
Shared libraries for mate-menus

%package preferences-category-menu
Group: System/Libraries
Summary: Categories for the preferences menu
Requires:	libmate-menus = %{version}-%{release}

%description preferences-category-menu
Categories for the preferences menu

%package devel
Group: Development/C
Summary: Development files for mate-menus
Requires:	libmate-menus = %{version}-%{release}

%description devel
Development files for mate-menus

%prep
%setup -q

%patch0 -p1 -b .add-categories

# fedora specific
# fix for usage of multimedia-menus, games-menu and wine-menu packages
sed -i -e '/<!-- End Other -->/ a\  <MergeFile>applications-merged/multimedia-categories.menu</MergeFile>' layout/mate-applications.menu
sed -i -e '/<MergeFile>applications-merged\/multimedia-categories.menu<\/MergeFile>/ a\  <MergeFile>applications-merged/games-categories.menu</MergeFile>' layout/mate-applications.menu
sed -i -e '/<MergeFile>applications-merged\/games-categories.menu<\/MergeFile>/ a\  <MergeFile>applications-merged/wine.menu</MergeFile>' layout/mate-applications.menu

# for the patch
NOCONFIGURE=1 ./autogen.sh
%patch33 -p0
%patch34 -p1
%patch1 -p1

%build
%configure \
 --disable-static \
 --enable-python \
 --enable-introspection=yes

make %{?_smp_mflags} V=1


%install
%{makeinstall_std}

find %{buildroot} -name '*.la' -exec rm -f {} ';'
find %{buildroot} -name '*.a' -exec rm -f {} ';'
chrpath --delete $RPM_BUILD_ROOT%{python_sitelibdir}/matemenu.so

%find_lang %{name} --with-gnome --all-name

%files -f %{name}.lang
%doc AUTHORS COPYING README
%config %{_sysconfdir}/xdg/menus/mate-preferences-categories.menu
%config %{_sysconfdir}/xdg/menus/mate-applications.menu
%config %{_sysconfdir}/xdg/menus/mate-settings.menu
%{_datadir}/mate-menus
%{_datadir}/mate/desktop-directories

%files -n libmate-menus
%{_libdir}/girepository-1.0/MateMenu-2.0.typelib
%{_libdir}/libmate-menu.so.2
%{_libdir}/libmate-menu.so.2.4.9
%{python_sitelibdir}/matemenu.so

%files devel
%{_datadir}/gir-1.0/MateMenu-2.0.gir
%{_libdir}/libmate-menu.so
%{_includedir}/mate-menus
%{_libdir}/pkgconfig/libmate-menu.pc


%changelog
