Group: Graphical desktop/Other
# BEGIN SourceDeps(oneline):
BuildRequires: /usr/bin/glib-gettextize
# END SourceDeps(oneline)
%define _libexecdir %_prefix/libexec
# %%name or %%version is ahead of its definition. Predefining for rpm 4.0 compatibility.
%define name mate-themes
%define version 3.20.7
# Conditional for release and snapshot builds. Uncomment for release-builds.
%global rel_build 1

# This is needed, because src-url contains branched part of versioning-scheme.
%global branch 3.20

%global rel_ver 3.20.7

# Settings used for build from snapshots.
%{!?rel_build:%global commit 5fec16803c5ff06fa31b7cab47c6d51a99f1acc7}
%{!?rel_build:%global commit_date 20151005}
%{!?rel_build:%global shortcommit %(c=%{commit};echo ${c:0:7})}
%{!?rel_build:%global git_ver git%{commit_date}-%{shortcommit}}
%{!?rel_build:%global git_rel .git%{commit_date}.%{shortcommit}}
%{!?rel_build:%global git_tar %{name}-%{version}-%{git_ver}.tar.xz}

Name:           mate-themes
Version:        %{rel_ver}
%if 0%{?rel_build}
Release:        alt1_2
%else
Release:        alt1_2
%endif
Summary:        MATE Desktop themes
License:        GPLv2+
URL:            http://mate-desktop.org
BuildArch:      noarch

# for downloading the tarball use 'spectool -g -R mate-themes.spec'
# Source for release-builds.
%{?rel_build:Source0:     http://pub.mate-desktop.org/releases/themes/%{branch}/%{name}-%{version}.tar.xz}
# Source for snapshot-builds.
%{!?rel_build:Source0:    http://git.mate-desktop.org/%{name}/snapshot/%{name}-%{commit}.tar.xz#/%{git_tar}}

BuildRequires:  mate-common
BuildRequires:  libgail-devel libgtk+2-devel
BuildRequires:  libgdk-pixbuf-devel

Requires:       mate-icon-theme
Requires:       libgtk-engines-default
Requires:       libgtk-engine-murrine
Source44:       import.info
Patch1:         mate-themes_0003-fix-menubar-view-for-LibreOffice.patch

%description
MATE Desktop themes

%prep
%if 0%{?rel_build}
# for releases
%setup -qn %{name}-%{version}
%else # 0%{?rel_build}
# for snapshots
%setup -qn %{name}-%{commit}
# needed for git snapshots
NOCONFIGURE=1 ./autogen.sh
%endif # 0%{?rel_build}
%patch1 -p2

%build
%configure --enable-icon-mapping

make %{?_smp_mflags} V=1

%install
%{makeinstall_std}

find %{buildroot} -name '*.la' -exec rm -rf {} ';'
find %{buildroot} -name '*.a' -exec rm -rf {} ';'

%post
for icon_theme in \
  ContrastHigh ;
do
  /bin/touch --no-create %{_datadir}/icons/${icon_theme} &> /dev/null || :
done

%postun
if [ $1 -eq 0 ]; then
for icon_theme in \
  ContrastHigh ;
do
  /bin/touch --no-create %{_datadir}/icons/${icon_theme} &> /dev/null || :

done
fi

%files
%doc AUTHORS COPYING README ChangeLog
%{_datadir}/themes/BlackMATE/
%{_datadir}/themes/BlueMenta/
%{_datadir}/themes/Blue-Submarine/
%{_datadir}/themes/ContrastHighInverse/
%{_datadir}/themes/GreenLaguna/
%{_datadir}/themes/Green-Submarine/
%{_datadir}/themes/HighContrast/metacity-1/metacity-theme-1.xml
%{_datadir}/themes/Menta/
%{_datadir}/themes/TraditionalOk/
%{_datadir}/themes/TraditionalGreen/
%{_datadir}/themes/Shiny/
%{_datadir}/icons/ContrastHigh/
%{_datadir}/icons/mate/cursors/


%changelog
