Group: Graphical desktop/Other
# BEGIN SourceDeps(oneline):
BuildRequires: /usr/bin/desktop-file-install /usr/bin/gdk-pixbuf-csource /usr/bin/glib-gettextize imake libX11-devel libXext-devel libXinerama-devel libXrandr-devel libXt-devel libgio-devel pkgconfig(glib-2.0) pkgconfig(gtk+-3.0) pkgconfig(pangoxft) pkgconfig(xcomposite) pkgconfig(xcursor) pkgconfig(xrender) xorg-cf-files
# END SourceDeps(oneline)
BuildRequires: libcanberra-gtk2-devel
%define _libexecdir %_prefix/libexec
%define oldname marco
%define fedora 23
# %%oldname or %%version is ahead of its definition. Predefining for rpm 4.0 compatibility.
%define name marco
%define version 1.12.1
# Conditional for release and snapshot builds. Uncomment for release-builds.
%global rel_build 1

# This is needed, because src-url contains branched part of versioning-scheme.
%global branch 1.12

# Settings used for build from snapshots.
%{!?rel_build:%global commit 62a708d461e08275d6b85985f5fa13fa8fbc85f7}
%{!?rel_build:%global commit_date 20131212}
%{!?rel_build:%global shortcommit %(c=%{commit};echo ${c:0:7})}
%{!?rel_build:%global git_ver git%{commit_date}-%{shortcommit}}
%{!?rel_build:%global git_rel .git%{commit_date}.%{shortcommit}}
%{!?rel_build:%global git_tar %{oldname}-%{version}-%{git_ver}.tar.xz}

Name:          mate-window-manager
Version:       %{branch}.1
%if 0%{?rel_build}
Release:       alt1_3
%else
Release:       alt1_3
%endif
Summary:       MATE Desktop window manager
License:       LGPLv2+ and GPLv2+
URL:           http://mate-desktop.org

# for downloading the tarball use 'spectool -g -R marco.spec'
# Source for release-builds.
%{?rel_build:Source0:     http://pub.mate-desktop.org/releases/%{branch}/%{oldname}-%{version}.tar.xz}
# Source for snapshot-builds.
%{!?rel_build:Source0:    http://git.mate-desktop.org/%{oldname}/snapshot/%{oldname}-%{commit}.tar.xz#/%{git_tar}}

# needed for fixing initial-setup issue, rhbz (#962009)
Source1:       mini-window.png
Source2:       stock_delete.png
Source3:       stock_maximize.png
Source4:       stock_minimize.png
Source5:       window.png

# needed for fixing initial-setup issue, rhbz (#962009)
Patch0:        marco_add-pixbuf-inline-icons_1.9.x.patch

BuildRequires: desktop-file-utils
BuildRequires: gtk2-devel
BuildRequires: libcanberra-devel
# needed for f23
%if 0%{?fedora} > 22
BuildRequires: libcanberra-gtk2
%endif
BuildRequires: libgtop2-devel
BuildRequires: libSM-devel
BuildRequireS: libsoup-devel
BuildRequires: libXdamage-devel
BuildRequires: mate-common
BuildRequires: zenity
BuildRequires: libstartup-notification-devel
BuildRequires: yelp-tools

Requires:      libmate-desktop
Requires:      libmarco-private = %{version}

# http://bugzilla.redhat.com/873342
# https://bugzilla.redhat.com/962009
Provides: firstboot(windowmanager) = marco

Provides: mate-window-manager%{?_isa} = %{version}-%{release}
Provides: mate-window-manager = %{version}-%{release}
Obsoletes: mate-window-manager < %{version}-%{release}
# rhbz (#1297958)
Obsoletes:     %{oldname} < 1.12.1-2
Source44: import.info
# http://bugzilla.gnome.org/show_bug.cgi?id=558723
Patch33: stop-spamming-xsession-errors.patch
# https://bugzilla.gnome.org/show_bug.cgi?id=598995
Patch34: Dont-focus-ancestor-window-on-a-different-workspac.patch
# https://bugzilla.gnome.org/show_bug.cgi?id=604319
Patch35: metacity-2.28-xioerror-unknown-display.patch

%description
MATE Desktop window manager

# to avoid that marco will install in other DE's by compiz-0.8.10
%package -n libmarco-private
Group: System/Libraries
Summary:       Libraries for marco
License:       LGPLv2+
# rhbz (#1297958)
Conflicts:     mate-window-manager < 1.12.1-2

%description -n libmarco-private
This package provides Libraries for marco.

%package devel
Group: Development/C
Summary:       Development files for marco
Requires:      mate-window-manager = %{version}
Requires:      libmarco-private = %{version}
Provides:      mate-window-manager-devel%{?_isa} = %{version}-%{release}
Provides:      mate-window-manager-devel = %{version}-%{release}
Obsoletes:     mate-window-manager-devel < %{version}-%{release}

%description devel
Development files for marco

%prep
%setup -n %{oldname}-%{version} -q%{!?rel_build:n %{oldname}-%{commit}}

%if 0%{?rel_build}
#NOCONFIGURE=1 ./autogen.sh
%else # 0%{?rel_build}
# needed for git snapshots
NOCONFIGURE=1 ./autogen.sh
%endif # 0%{?rel_build}
%patch33 -p1
%patch34 -p1
%patch35 -p1

# needed for missing `po/Makefile.in.in'
#cp %{SOURCE1} src/mini-window.png
#cp %{SOURCE2} src/stock_delete.png
#cp %{SOURCE3} src/stock_maximize.png
#cp %{SOURCE4} src/stock_minimize.png
#cp %{SOURCE5} src/window.png

#%patch0 -p1 -b .inline-icons

# needed for the patch and for git snapshot builds
#autoreconf -if
#NOCONFIGURE=1 ./autogen.sh

%build
%autoreconf -fisv
%configure --disable-static           \
           --disable-schemas-compile  \
           --with-gtk=2.0             \
           --with-x

# fix rpmlint unused-direct-shlib-dependency warning
sed -i -e 's! -shared ! -Wl,--as-needed\0!g' libtool

make %{?_smp_mflags} V=1


%install
%{makeinstall_std}

find %{buildroot} -name '*.la' -exec rm -vf {} ';'

desktop-file-install                                \
        --delete-original                           \
        --dir=%{buildroot}%{_datadir}/applications  \
%{buildroot}%{_datadir}/applications/marco.desktop

# remove needless gsettings convert file
rm -f  %{buildroot}%{_datadir}/MateConf/gsettings/marco.convert

%find_lang %{oldname} --with-gnome --all-name


%files
%doc AUTHORS COPYING README ChangeLog
%{_bindir}/marco
%{_bindir}/marco-message
%{_datadir}/applications/marco.desktop
%{_datadir}/themes/ClearlooksRe
%{_datadir}/themes/Dopple-Left
%{_datadir}/themes/Dopple
%{_datadir}/themes/DustBlue
%{_datadir}/themes/Spidey-Left
%{_datadir}/themes/Spidey
%{_datadir}/themes/Splint-Left
%{_datadir}/themes/Splint
%{_datadir}/themes/WinMe
%{_datadir}/themes/eOS
%dir %{_datadir}/marco
%dir %{_datadir}/marco/icons
%{_datadir}/marco/icons/marco-window-demo.png
%{_datadir}/mate-control-center/keybindings/50-marco*.xml
%{_datadir}/mate/wm-properties
%{_mandir}/man1/*

%files -n libmarco-private -f %{oldname}.lang
%{_libdir}/libmarco-private.so.0*
%{_datadir}/glib-2.0/schemas/org.mate.marco.gschema.xml

%files devel
%{_bindir}/marco-theme-viewer
%{_bindir}/marco-window-demo
%{_includedir}/marco-1
%{_libdir}/libmarco-private.so
%{_libdir}/pkgconfig/libmarco-private.pc
%{_mandir}/man1/marco-theme-viewer.1.*
%{_mandir}/man1/marco-window-demo.1.*


%changelog
