Name: maven-license-plugin
Version: 1.8.0
Summary: Maven plugin to update header licenses of source files
License: ASL 2.0
Url: http://code.google.com/p/maven-license-plugin
Epoch: 0
Packager: Igor Vlasenko <viy@altlinux.ru>
Provides: maven-license-plugin = 1.8.0-18.fc23
Provides: mvn(com.mycila.maven-license-plugin:maven-license-plugin) = 1.8.0
Provides: mvn(com.mycila.maven-license-plugin:maven-license-plugin:pom:) = 1.8.0
Requires: java-headless
Requires: java-headless
Requires: jpackage-utils
Requires: jpackage-utils
Requires: maven
Requires: maven-shared
Requires: mvn(com.mycila.xmltool:xmltool)
Requires: mvn(org.apache.maven:maven-compat)
Requires: mvn(org.apache.maven:maven-plugin-api)
Requires: mvn(org.apache.maven:maven-project)
Requires: mvn(org.codehaus.plexus:plexus-utils)
Requires: xmltool

BuildArch: noarch
Group: Development/Java
Release: alt5jpp
Source: maven-license-plugin-1.8.0-18.fc23.cpio

%description
maven-license-plugin is a Maven plugin that help you managing license
headers in source files. Basically, when you are developing a project
either in open source or in a company, you often need to add at the top
of your source files a license to protect your work.
This plugin lets you maintain the headers, including checking if the
header is present, generating a report and of course having the
possibility to update / reformat missing license headers.

# sometimes commpress gets crazy (see maven-scm-javadoc for details)
%set_compress_method none
%prep
cpio -idmu --quiet --no-absolute-filenames < %{SOURCE0}

%build
cpio --list < %{SOURCE0} | sed -e 's,^\.,,' > %name-list

%install
mkdir -p $RPM_BUILD_ROOT
for i in usr var etc; do
[ -d $i ] && mv $i $RPM_BUILD_ROOT/
done


%files -f %name-list

%changelog
