%def_without smb
%def_with    gpm
%define fullname MidnightCommander

Name: mc
Version: 4.8.27
Release: alt0.M80P.1

# '-gitYYYYMMDD' or ''
%define ver_date ''

License: GPL-3.0-or-later
Summary: An user-friendly file manager and visual shell
Group: File tools
Url: http://midnight-commander.org/

Source0: %name-%version.tar
Source1: synce-mcfs.tar
Source2: mc-dnlike.color
Source3: mc-dark.color
Source4: mc-16.png
Source5: mc-32.png
Source6: mc.zsh
Source7: rpm-4.0.4-helper

%add_findreq_skiplist */lib/mc/ext.d/*
%add_findreq_skiplist */lib/mc/extfs.d/*

Patch0: %name-%version-%release.patch

Patch1: mc-4.8.24-alt-wrapper.patch
Patch2: mc-4.7.5.1-alt-defaults.patch
Patch3: mc-4.8.20-alt-menu.patch

# Misc

# a part of http://www.midnight-commander.org/ticket/1480
Patch101: mc-4.7.0.2-savannah-edit-homekey.patch

# http://www.midnight-commander.org/ticket/2496
Patch102: mc-4.8.20-alt-forceexec.patch

# http://www.midnight-commander.org/ticket/34
Patch103: mc-4.8.24-alt-extfs-udar.patch

# https://src.fedoraproject.org/rpms/mc/raw/rawhide/f/mc-python3.patch
# https://github.com/MidnightCommander/mc/pull/149
Patch104: mc-4.8.25-python3.patch

# http://www.midnight-commander.org/ticket/4323
Patch105: mc-4.8.27-4323_fix_segfault_on_change_panel_mode.patch

Conflicts: %name-data
Conflicts: %name-locales
Conflicts: %name-doc

Obsoletes: %name-data
Obsoletes: %name-locales
Obsoletes: %name-doc

BuildRequires: rpm-build-python3

BuildPreReq: glib2-devel libe2fs-devel
BuildPreReq: groff-base cvs libX11-devel unzip
BuildPreReq: libslang2-devel libmount-devel
%if_with gpm
BuildPreReq: libgpm-devel
%endif

%add_findreq_skiplist %_sysconfdir/mc/edit.indent.rc
%add_findreq_skiplist %_sysconfdir/mc/edit.spell.rc
%add_findreq_skiplist %_libexecdir/mc/extfs.d/*

# Polish translations (*.pl) recognized as Perl code
%add_findreq_skiplist %_datadir/mc/mc.hlp*
%add_findreq_skiplist %_datadir/mc/mc.hint*

%description
Midnight Commander is a visual shell much like a file manager, only
with way more features. It is text mode, but also includes mouse
support if you are running GPM. Its coolest feature is the ability
to ftp or ssh files access, view various archive files (include cpio),
poke into RPMs and DEBs for specific files and more others.

%package full
Summary: Meta package for install Midnight Commander with packages which possible needed.
Group: File tools
BuildArch: noarch
Obsoletes: %name-complete
Requires: %name
Requires: cdrkit-utils sqlite3

%description full
This package pulls Midnight Commander with packages which can be
needed for working additional components (some vfs for example).

%prep
%setup -a1
%patch0 -p1

# ALT
%patch1 -p1
%patch2 -p1
%patch3 -p0

# Misc
#patch101 -p1
%patch102 -p1
%patch103 -p1
%patch104 -p1
%patch105 -p1

%build
cat <<EOF > mc-version.h
#ifndef MC_CURRENT_VERSION
#define MC_CURRENT_VERSION "@@VERSION@@"
#endif
EOF

sed 's|@@VERSION@@|%version-%release%ver_date|' -i mc-version.h

# http://midnight-commander.org/ticket/3750 adds support of
# transaction scripts which incompatible with the rpm 4.0.4
# in ALT Linux branches before p9.
cp -f %SOURCE7 src/vfs/extfs/helpers/rpm

#%%autoreconf
./autogen.sh

%configure %{?_with_smb:--enable-vfs-smb --with-smb-configdir=%_sysconfdir/samba} \
	PYTHON=%__python3 \
	--enable-extcharset \
	--enable-vfs-undelfs

%make_build

%install
%makeinstall_std

install -d %buildroot%_sysconfdir/{profile.d,bashrc.d}
mv %buildroot%_libexecdir/mc/mc.csh %buildroot%_sysconfdir/profile.d/
mv %buildroot%_libexecdir/mc/mc.sh %buildroot%_sysconfdir/bashrc.d/
install -m755 %SOURCE6 %buildroot%_sysconfdir/profile.d/mc.sh
# Install DosNavigator color scheme
install -m644 %SOURCE2 .
# Install Dark color scheme
install -m644 %SOURCE3 .

# Install SynCE VFS ( http://www.midnight-commander.org/ticket/2905 )
install -m755 synce-mcfs/src/synce* %buildroot%_libexecdir/%name/extfs.d/

# http://www.midnight-commander.org/ticket/2314
# mc.desktop
cat <<__EOF__>%name.desktop
[Desktop Entry]
Version=1.0
Type=Application
Name=Midnight Commander
Comment=Visual shell and file manager
Comment[ru]=Визуальная оболочка и диспетчер файлов 
Icon=%fullname
Exec=%name
Terminal=true
Categories=ConsoleOnly;System;FileTools;FileManager;
__EOF__
install -pD -m644 %name.desktop %buildroot%_desktopdir/%name.desktop
# mcedit.desktop
cat <<__EOF__>mcedit.desktop
[Desktop Entry]
Version=1.0
Type=Application
Name=mcedit
GenericName=Text Editor
GenericName[ru]=Текстовый редактор
Comment=Internal file editor of GNU Midnight Commander
Comment[ru]=Встроенный текстовый редактор GNU Midnight Commander
Icon=%fullname
Exec=mcedit
Terminal=true
Categories=ConsoleOnly;Utility;TextEditor;
__EOF__
install -pD -m644 mcedit.desktop %buildroot%_desktopdir/mcedit.desktop

# icons
install -pD -m644 %SOURCE4 %buildroot%_miconsdir/%fullname.png
install -pD -m644 %SOURCE5 %buildroot%_niconsdir/%fullname.png

%find_lang --with-man %name

%files -f %name.lang
%_bindir/mc
%_bindir/mcedit
%_bindir/mcview
%_bindir/mcdiff
%_libexecdir/mc/
%config(noreplace) %_sysconfdir/bashrc.d/*
%config(noreplace) %_sysconfdir/profile.d/*
%dir %_sysconfdir/mc
%config(noreplace) %_sysconfdir/mc/*edit*
%config(noreplace) %_sysconfdir/mc/filehighlight.ini
%config(noreplace) %_sysconfdir/mc/mc.ext
%config(noreplace) %_sysconfdir/mc/mc.keymap
%config(noreplace) %_sysconfdir/mc/mc.default.keymap
%config(noreplace) %_sysconfdir/mc/mc.emacs.keymap
%config(noreplace) %_sysconfdir/mc/mc.menu
%config(noreplace) %_sysconfdir/mc/sfs.ini

%_man1dir/*

%_datadir/mc/
%_desktopdir/%name.desktop
%_desktopdir/mcedit.desktop
%_niconsdir/%fullname.png
%_miconsdir/%fullname.png

%doc AUTHORS doc/FAQ doc/HACKING doc/MAINTAINERS doc/NEWS doc/README
%doc doc/README.QNX doc/TODO doc/filehighlight.txt contrib/README.xterm
%doc mc-dnlike.color mc-dark.color

%files full

%changelog
