Name: mdadm
Version: 3.3.4
Release: alt1

Summary: A tool for managing Soft RAID under Linux
License: GPLv2+
Group: System/Configuration/Hardware
Url: http://neil.brown.name/blog/mdadm

# http://git.altlinux.org/gears/m/mdadm.git
Source: %name-%version-%release.tar

BuildRequires: binutils-devel

# due to /lib/udev/rules.d/64-md-raid.rules
Conflicts: udev < 151

%description
mdadm is a program that can be used to create, manage, and monitor
Linux MD (Software RAID) devices.

As such is provides similar functionality to the raidtools packages.
The particular differences to raidtools is that mdadm is a single
program, and it can perform (almost) all functions without a
configuration file (that a config file can be used to help with
some common tasks).

%prep
%setup -n %name-%version-%release

%build
%make_build mdadm mdmon CXFLAGS='%optflags' SYSCONFDIR='%_sysconfdir'
bzip2 -9fk ChangeLog

%install
%makeinstall_std install-systemd MANDIR=%_mandir BINDIR=/sbin SYSTEMD_DIR=%_unitdir
install -pD -m755 alt/mdadm.init %buildroot%_initdir/mdadm
install -pD -m755 misc/syslog-events %buildroot/sbin/mdadm-syslog-events
install -pD -m600 alt/mdadm.conf %buildroot%_sysconfdir/mdadm.conf
# install -pD -m644 alt/mdadm.service %buildroot%_unitdir/mdadm.service
ln -r -s %buildroot%_unitdir/mdmonitor.service %buildroot%_unitdir/mdadm.service

install -pD -m755 alt/checkarray %buildroot%_datadir/mdadm/checkarray
install -pD -m644 alt/mdadm.sysconfig %buildroot%_sysconfdir/sysconfig/mdadm
install -pD -m644 alt/mdadm.crond %buildroot%_sysconfdir/cron.d/mdadm


%post -f alt/raidtabtomdadm.sh
%post_service mdadm

%preun
%preun_service mdadm

%files
/sbin/md*
/lib/udev/rules.d/63-md-raid-arrays.rules
/lib/udev/rules.d/64-md-raid-assembly.rules
%config(noreplace,missingok) %_sysconfdir/mdadm.conf
%config(noreplace) %_sysconfdir/sysconfig/mdadm
%_sysconfdir/cron.d/mdadm
%_mandir/man?/md*
%_initdir/mdadm
%_datadir/mdadm/
%_unitdir/*
/lib/systemd/system-shutdown/mdadm.shutdown
%doc TODO ChangeLog.bz2 mdadm.conf-example ANNOUNCE-%version alt/README*

%changelog
