%def_disable static
%def_disable gmdb2

Name: mdbtools
Version: 0.7.1
Release: alt1

Summary: Utilities for use M$ Access databases under Linux

Group: Databases
License: GPL/LGPL
Url: https://github.com/brianb/mdbtools

Source: %name-%version.tar.gz

Requires: lib%name = %version-%release

BuildRequires: flex libreadline-devel libunixODBC-devel glib2-devel
BuildRequires: gtk-doc txt2man
%{?_enable_gmdb2:BuildRequires: libglade-devel libgnomeui-devel librarian}

%description
MDB Tools is a set of libraries and programs to help you use Microsoft
Access file in various settings.

This package provides:
Several command line utilities to list tables, export schema, and data,
show the version of the files, and other useful stuff.
mdb-sql - a command line SQL tool that allows one to type sql queries
and get results.

%package -n gmdb
Summary: MS Access MDB File Viewer
Group: Databases
Requires: lib%name = %version-%release

%description -n gmdb
gmdb - The GTK2 MDB File Viewer and debugger. Still alpha, but making
great progress.

%package -n lib%name
Summary: MDB Tools shared libraries
Group: System/Libraries

%description -n lib%name
MDB Tools is a set of libraries and programs to help you use Microsoft
Access file in various settings.

This package contains:
libmdb		the core library that allows access to MDB files programatically.
libmdbsql	builds on libmdb to provide a SQL engine (ala Jet)
libmdbodbc	an ODBC driver for use with unixODBC driver manager. Allows
		one to use MDB files with PHP for example.

%package -n lib%name-devel
Summary: MDB Tools development files and libraries
Group: Development/C
Requires: lib%name = %version-%release

%description -n lib%name-devel
This package contains the files needed to build packages that depend on
MDB Tools.

%package -n lib%name-devel-static
Summary: MDB Tools static libraries
Group: Development/C
Requires: lib%name-devel = %version-%release

%description -n lib%name-devel-static
This package contains the libraries needed to build applications
statically linked with MDB Tools.

%prep
%setup

%build
%autoreconf
%configure \
    %{subst_enable static} \
    --with-unixodbc=%_prefix \
    %{subst_enable gmdb2} \
    --enable-gtk-doc

%make_build

%install
%makeinstall_std

%files
%_bindir/*
%{?_enable_gmdb2:%exclude %_bindir/gmdb2}
%_man1dir/*
%doc AUTHORS NEWS README TODO ChangeLog doc/faq.html

%if_enabled gmdb2
%files -n gmdb
%_bindir/gmdb2
%_datadir/gmdb
%doc %_datadir/gnome/help/gmdb
%endif

%files -n lib%name
%_libdir/*.so.*

%files -n lib%name-devel
%_includedir/*
%_libdir/*.so
%_pkgconfigdir/*

%if_enabled static
%files -n lib%name-devel-static
%_libdir/*.a
%endif

%changelog
