Name: mediainfo
Version: 0.7.99
Release: alt0.M80P.1

Group: File tools
Summary: MediaInfo supplies information about a video or audio file
License: LGPL
Url: http://mediainfo.sourceforge.net

Source: https://mediaarea.net/download/source/%name/%version/%{name}_%{version}.tar.xz

Requires: lib%name >= %version

BuildRequires(pre): rpm-macros-kde-common-devel

BuildRequires: gcc-c++
BuildRequires: dos2unix
BuildRequires: zlib-devel
BuildRequires: libpango-devel
BuildRequires: libzen-devel >= 0.4.35
BuildRequires: libmediainfo-devel >= %version
BuildRequires: libwxGTK-devel
BuildRequires: sgml-common

%package gui
Group: File tools
Summary: MediaInfo supplies information about a video or audio file
Requires: lib%name >= %version

%package gui-KDE3
Group: File tools
Summary: KDE3 related MediaInfo files
BuildArch: noarch
Requires: %name-gui = %version-%release
Requires: kdebase-konqueror < 4.0

%package gui-KDE4
Group: File tools
Summary: KDE4 related MediaInfo files
BuildArch: noarch
Requires: %name-gui = %version-%release
Requires: kde4libs

%description
MediaInfo supplies technical and tag information about a video or audio file

What information can I get from MediaInfo?
General: title, author, director, album, track number, date, duration...
Video: codec, aspect, fps, bitrate...
Audio: codec, sample rate, channels, language, bitrate...
Text: language of subtitle
Chapters: number of chapters, list of chapters

What format (container) does MediaInfo support?
Video: MKV, OGM, AVI, DivX, WMV, QuickTime, Real, MPEG-1, MPEG-2,
       MPEG-4, DVD (VOB)...
(Codecs: DivX, XviD, MSMPEG4, ASP, H.264, AVC...)
Audio: OGG, MP3, WAV, RA, AC3, DTS, AAC, M4A, AU, AIFF...
Subtitles: SRT, SSA, ASS, SAMI...

This package includes the command line interface

%description gui
MediaInfo supplies technical and tag information about a video or audio file

What information can I get from MediaInfo?
General: title, author, director, album, track number, date, duration...
Video: codec, aspect, fps, bitrate...
Audio: codec, sample rate, channels, language, bitrate...
Text: language of subtitle
Chapters: number of chapters, list of chapters

What format (container) does MediaInfo support?
Video: MKV, OGM, AVI, DivX, WMV, QuickTime, Real, MPEG-1, MPEG-2,
       MPEG-4, DVD (VOB)...
(Codecs: DivX, XviD, MSMPEG4, ASP, H.264, AVC...)
Audio: OGG, MP3, WAV, RA, AC3, DTS, AAC, M4A, AU, AIFF...
Subtitles: SRT, SSA, ASS, SAMI...

This package contains the graphical user interface.

To combine with KDE install KDE-related package

%description gui-KDE3
This package contains KDE3 related MediaInfo files for konqueror

%description gui-KDE4
This package contains KDE4 related MediaInfo files for konqueror

%prep
%setup -q -T -b 0 -n MediaInfo

%build
pushd Project/GNU/CLI
%autoreconf
%configure --disable-staticlibs --with-dll
%make
popd
pushd Project/GNU/GUI
%autoreconf
%configure --disable-staticlibs --with-dll
%make
popd

%install
pushd Project/GNU/CLI
%makeinstall_std
popd
pushd Project/GNU/GUI
%makeinstall_std
popd
# Add here commands to install the package
cp Release/ReadMe_CLI_Linux.txt .
cp Release/ReadMe_GUI_Linux.txt .

install -m 644 Source/Resource/Image/MediaInfo.png %buildroot%_pixmapsdir/mediainfo.png
install -dm 755 %buildroot%_liconsdir
install -m 644 Source/Resource/Image/MediaInfo.png %buildroot%_liconsdir/mediainfo.png

install -dm 755 %buildroot%_K3apps/konqueror/servicemenus/
grep -v '^Encoding=' Project/GNU/GUI/mediainfo-gui.kde3.desktop >%buildroot%_K3apps/konqueror/servicemenus/mediainfo-gui.desktop
install -dm 755 %buildroot%_K4srv/ServiceMenus/
grep -v '^Encoding=' Project/GNU/GUI/mediainfo-gui.kde4.desktop >%buildroot%_K4srv/ServiceMenus/mediainfo-gui.desktop

%files
%doc ReadMe_CLI_Linux.txt
%_bindir/%name

%files gui
%doc ReadMe_GUI_Linux.txt
%_bindir/%name-gui
%_desktopdir/%name-gui.desktop
%_datadir/appdata/%name-gui.appdata.xml
%_datadir/apps/konqueror/servicemenus/%name-gui.desktop
%_iconsdir/hicolor/*x*/apps/%name.png
%_iconsdir/hicolor/scalable/apps/%name.svg
%_pixmapsdir/%name.xpm
%_pixmapsdir/%name.png

%files gui-KDE3
%_K3apps/konqueror/servicemenus/%name-gui.desktop

%files gui-KDE4
%_K4srv/ServiceMenus/%name-gui.desktop

%changelog
