%define rev 7bf6fe75
Name: megaglest
Version: 3.9.2
Release: alt1.%rev
Summary: Glest is a project for making a free 3d real-time customizable strategy game
License: GPLv3
Group: Games/Strategy
Url: http://megaglest.sourceforge.net
Packager: Andrew Clark <andyc@altlinux.org>

Source: http://sourceforge.net/projects/%name/files/megaglest_3.2.3/%name-source-%version.tar.bz2
Source2: %name.sh
Source3: %name.png
Source4: %name.desktop

Patch2: megaglest-3.6.0.3-alt-gcc4.7.patch

# Automatically added by buildreq on Sat Jan 11 2014
# optimized out: cmake-modules fontconfig libGL-devel libGLU-devel libX11-devel libfreetype-devel libgdk-pixbuf libogg-devel libstdc++-devel libwayland-client libwayland-server libxerces-c pkg-config xorg-kbproto-devel xorg-xproto-devel zlib-devel
BuildRequires: cmake fontconfig-devel gcc-c++ libSDL-devel libXau-devel libXdmcp-devel libcurl-devel libftgl-devel libglew-devel libjpeg-devel liblua5-devel libopenal-devel libpng-devel libvorbis-devel libwxGTK-devel libxerces-c-devel libxml2-devel

Requires: %name-data = %version 

%description
Glest is a project for making a free 3d real-time customizable
strategy game. Current version is fully playable, includes
single player game against CPU controlled players, two factions
with their corresponding tech trees, units, buildings and some maps.

%prep
%setup  -n %name-source-%version
%patch2 -p2
sed -in '/^#include <curl\/types\.h>/d' source/shared_lib/sources/platform/posix/miniftpclient.cpp
sed -i 's#DataPath=$APPLICATIONDATAPATH#DataPath=/usr/share/games/megaglest/#g' %_builddir/%name-source-%version/mk/linux/glest.ini

%build
%add_optflags -fpermissive
cmake --debug-output -D CMAKE_CXX_FLAGS="%optflags" -D CMAKE_C_FLAGS="%optflags" -D WANT_SVN_STAMP="NO" -D CUSTOM_DATA_INSTALL_PATH="%_datadir/games/megaglest/" -D WANT_STATIC_LIBS="no" CMakeLists.txt
%make_build VERBOSE=1


%install
# let's create directory structure...
mkdir -p %buildroot{%_bindir,%_niconsdir,%_desktopdir,%_datadir/%name}

# and install what we need where we need it to be...
install -pm755 source/glest_game/%name %buildroot%_bindir/%name-bin
install -pm755 %SOURCE2 %buildroot%_bindir/%name

install -pm 644 %SOURCE3 %buildroot%_niconsdir/%name.png
install -pm 644 %SOURCE4 %buildroot%_desktopdir/%name.desktop

install -pm 644 %_builddir/%name-source-%version/mk/linux/glest.ini %buildroot%_datadir/%name
install -pm 644 %_builddir/%name-source-%version/mk/linux/glestkeys.ini %buildroot%_datadir/%name


%files
%doc docs/
%_bindir/*
%_niconsdir/%name.png
%_desktopdir/%name.desktop
%_datadir/%name/*.ini

%changelog
