Name: memtest86+
Version: 5.01
Release: alt1

Summary: Memory test for x86 architecture
License: GPL
Group: System/Kernel and hardware

Url: http://www.memtest.org
Source: %url/download/%version/%name-%version.tar.gz
# reported upstream
Patch0:   memtest86+-5.01-no-scp.patch
# patches to get memtest86+ working with gcc-4.7.2 or later + PCI scan fix
# these patches were taken from Mageia
# upstream report containing link to the patches:
# http://forum.canardpc.com/threads/83443-Memtest86-V5.01-crashes-with-gcc-4.7.2-or-later
Patch1:   memtest86+-5.01-no-optimization.patch
Patch2:   memtest86+-5.01-compile-fix.patch
Patch3:   memtest86+-5.01-array-size-fix.patch
Packager: Michael Shigorin <mike@altlinux.org>

ExclusiveArch: %ix86 x86_64
Requires(post,preun): bootloader-utils >= 0.3
BuildRequires: dev86

%description
Memtest86 is thorough, standalone memory test for x86 systems. It is
a standalone program and can be loaded from either a disk partition via
lilo or a floppy disk. Memtest86 uses a "moving inversions" algorithm
that is proven to be effective in finding memory errors.  The BIOS based
memory test is just a quick check that will often miss many of the
failures that are detected by Memtest86.

The ELF version should be used for booting from grub,
and avoids the following errors:
"Error 7: Loading below 1MB is not supported"
"Error 13: Invalid or unsupported executable format"
"Error 28: Selected item cannot fit into memory"

%description -l ru_RU.UTF-8
Тщательный и самостоятельный тест памяти для x86-систем, который может
быть загружен или с жесткого диска при помощи LILO/GRUB, или с дискеты.

Тест использует алгоритм "движущихся инверсий", доказавший свою
эффективность при обнаружении сбоев памяти. Не обращайте внимания на
"тест" BIOS: он практически ничего не значит, так как пропустит много
ошибок из тех, которые обнаружит memtest86.

Также может использоваться для создания загрузочной тест-дискеты.

%description -l uk_UA.UTF-8
Ретельний та самостійний тест пам'яті для x86-систем, що може бути
завантажений як з жорсткого диску за допомогою LILO/GRUB, так і з
дискети.

Тест використовує алгоритм "рухаючихся інверсій", який довів свою
ефективність при визначенні негараздів із пам'яттю. Не звертайте уваги
на "тест" BIOS: він практично нічого не означає, тому що пройде повз
багатьох збоїв з тих, що знаходить memtest86.

Також може використовуватися для створення завантажувальної
тест-дискети.

%prep
%setup
%patch0 -p1 -b .no-scp
%patch1 -p1 -b .no-optimization
%patch2 -p1 -b .compile-fix
%patch3 -p1 -b .array-size-fix

sed -i -e's,0x5000,0x100000,' memtest.lds
%ifarch x86_64
sed -i -e's,$(LD) -s -T memtest.lds,$(LD) -s -T memtest.lds -z max-page-size=0x1000,' Makefile
%endif

%build
make

%install
install -pDm644 memtest.bin %buildroot/boot/memtest-%version.bin
install -pDm644 memtest %buildroot/boot/elf-memtest-%version
mkdir -p %buildroot%_sbindir
ln -s `relative /sbin/installkernel %_sbindir/installmemtest86+` \
	%buildroot%_sbindir/installmemtest86+

%post
%_sbindir/installmemtest86+ %version

%preun
%_sbindir/installmemtest86+ --remove %version

%files
/boot/memtest-%version.bin
/boot/elf-memtest-%version
%_sbindir/installmemtest86+
%doc README* FAQ

%changelog
