%define libname mesonbuild
%def_disable check

Name: meson
Version: 0.45.1
Release: alt1

Summary: High productivity build system
Group: Development/Python3
License: ASL 2.0
Url: http://mesonbuild.com/

Source: https://github.com/mesonbuild/meson/archive/%version/%name-%version.tar.gz
Source1: %name.macros
Source2: %name.env

BuildArch: noarch

%define python_ver 3.5

Requires: python3 >= %python_ver
Requires: ninja-build

BuildRequires: rpm-build-python3 python3-devel >= %python_ver python3-module-setuptools
BuildRequires: ninja-build
%if_enabled check
BuildRequires: gcc gcc-c++ gcc-fortran gcc-objc gcc-objc++
BuildRequires: java-devel /proc
BuildRequires: mono4-core mono4-devel
BuildRequires: boost-devel
BuildRequires: libgtest-devel
BuildRequires: libgmock-devel
BuildRequires: qt5-base-devel
BuildRequires: vala
BuildRequires: libwxGTK3.0-devel
BuildRequires: flex bison
BuildRequires: gnustep-base-devel
BuildRequires: git
BuildRequires: pkgconfig(protobuf) protobuf-c-compiler
BuildRequires: pkgconfig(glib-2.0)
BuildRequires: pkgconfig(gobject-introspection-1.0) python3-module-pygobject3 gtk-doc
BuildRequires: pkgconfig(zlib)
BuildRequires: python3-module-Cython
%endif

%description
Meson is a build system designed to optimize programmer productivity.
It aims to do this by providing simple, out-of-the-box support for modern
software development tools and practices, such as unit tests, coverage
reports, Valgrind, CCache and the like.

%prep
%setup

%build
%python3_build

%install
%python3_install
install -Dpm 0644 %SOURCE1 %buildroot%_rpmmacrosdir/%name
install -Dpm 0755 %SOURCE2 %buildroot%_rpmmacrosdir/%name.env

%check
MESON_PRINT_TEST_OUTPUT=1 ./run_tests.py

%files
%_bindir/%name
%_bindir/%{name}conf
%_bindir/%{name}introspect
%_bindir/%{name}test
%_bindir/wraptool
%python3_sitelibdir/%libname/
%python3_sitelibdir/%name-%version-*.egg-info/
%_man1dir/%name.1.*
%_man1dir/%{name}conf.1.*
%_man1dir/%{name}introspect.1.*
%_man1dir/%{name}test.1.*
%_man1dir/wraptool.1.*
%_rpmmacrosdir/%name
%_rpmmacrosdir/%name.env
%doc COPYING README.*


%changelog
