%define ver_major 2.34
%def_disable static
%def_enable compositor
%def_enable render
%def_enable shape

Name: metacity
Version: %ver_major.13
Release: alt3

Summary: Metacity window manager
License: %gpl2plus
Group: Graphical desktop/GNOME
Packager: GNOME Maintainers Team <gnome@packages.altlinux.org>
Url: http://ftp.gnome.org/pub/gnome/sources/%name

Source: %gnome_ftp/%name/%ver_major/%name-%version.tar.xz

# http://bugzilla.gnome.org/show_bug.cgi?id=558723
Patch4: stop-spamming-xsession-errors.patch
# http://bugzilla.gnome.org/show_bug.cgi?id=135056
Patch5: dnd-keynav.patch
# http://bugzilla.gnome.org/show_bug.cgi?id=588119
# https://bugzilla.gnome.org/show_bug.cgi?id=598995
Patch16: Dont-focus-ancestor-window-on-a-different-workspac.patch
# https://bugzilla.gnome.org/show_bug.cgi?id=599097
Patch18: For-mouse-and-sloppy-focus-return-to-mouse-mode-on.patch
# https://bugzilla.gnome.org/show_bug.cgi?id=599248
Patch19: Add-nofocuswindows-preference-to-list-windows-that.patch
Patch119: Exclude-the-current-application-from-no_focus_window.patch
# https://bugzilla.gnome.org/show_bug.cgi?id=599261
Patch20: Add-a-newwindowsalwaysontop-preference.patch
Patch120: Apply-new_windows_always_on_top-to-newly-raised-acti.patch
# https://bugzilla.gnome.org/show_bug.cgi?id=559816
Patch24: metacity-2.28-empty-keybindings.patch
# https://bugzilla.gnome.org/show_bug.cgi?id=604319
Patch25: metacity-2.28-xioerror-unknown-display.patch
# https://bugzilla.gnome.org/show_bug.cgi?id=599181
Patch28: Stop-confusing-GDK-s-grab-tracking.patch
# https://bugzilla.gnome.org/show_bug.cgi?id=622517
Patch29: Allow-breaking-out-from-maximization-during-mouse.patch

%define theme_prefix theme
%define old_theme_prefix themes

# From configure.in
%define gtk_ver 2.24.0
%define pango_ver 1.2.0
%define glib_ver 2.25.10
%define startup_notification_ver 0.7
%define xcomposite_ver 0.2
%define gsds_ver 3.3.0

Obsoletes: %name-gnome
Provides: %name-gnome = %version-%release

Requires: %name-theme = %version-%release
Requires: lib%name = %version-%release
Requires: zenity

# From configure.in
BuildPreReq: rpm-build-gnome rpm-build-licenses
BuildPreReq: intltool >= 0.34.90
BuildPreReq: libgtk+2-devel >= %gtk_ver
BuildPreReq: libpango-devel >= %pango_ver
BuildPreReq: libgio-devel >= %glib_ver
BuildPreReq: libstartup-notification-devel >= %startup_notification_ver
BuildPreReq: gsettings-desktop-schemas-devel >= %gsds_ver
%if_enabled compositor
BuildPreReq: libXcomposite-devel >= %xcomposite_ver
BuildRequires: libXfixes-devel libXrender-devel libXdamage-devel libXtst-devel
%endif
%{?_enable_render:BuildRequires: libXrender-devel}
BuildRequires: libXcursor-devel libXt-devel libXinerama-devel
%{?_enable_shape:BuildRequires: libXext-devel}
BuildRequires: yelp-tools itstool zenity libcanberra-gtk2-devel
BuildRequires: libXrandr-devel libX11-devel libSM-devel libICE-devel perl-XML-Parser libgtop-devel

%description
Metacity is a simple window manager that integrates nicely with
GNOME 2. It can also be used as a standalone, EWMH-compliant window
manager.
Note: to use Metacity with GNOME, you should install %name-gnome package.

%package -n lib%name
Summary: Shared library for Metacity
Group: System/Libraries

%description -n lib%name
This package contains shared library needed to run Metacity.

%package -n lib%name-devel
Summary: Development files for lib%name
Group: Development/C
Requires: lib%name = %version-%release
Requires: libgtk+2-devel >= %gtk_ver

%description -n lib%name-devel
This package contains headers and development libraries for lib%name

%package -n lib%name-devel-static
Summary: Static version of lib%name
Group: Development/C
Requires: lib%name-devel = %version-%release

%description -n lib%name-devel-static
This package contains the lib%name static library.

%package %{theme_prefix}s-default
Summary: Metacity default themes
Group: Graphical desktop/GNOME
BuildArch: noarch
Obsoletes: %name-themes < 2.14.0
Provides: %name-themes = %version-%release
Requires: %name-%theme_prefix-atlanta = %version-%release	%name-%theme_prefix-bright = %version-%release
Requires: %name-%theme_prefix-crux = %version-%release		%name-%theme_prefix-esco = %version-%release
Requires: %name-%theme_prefix-gorilla = %version-%release	%name-%theme_prefix-metabox = %version-%release
Requires: %name-%theme_prefix-simple = %version-%release

%description %{theme_prefix}s-default
This is virtual package that provides default themes for Metacity.

%package %theme_prefix-atlanta
Summary: Metacity theme - Atlanta
Group: Graphical desktop/GNOME
BuildArch: noarch
Provides: %name-theme = %version-%release
Obsoletes: %name-%old_theme_prefix-atlanta = %version-%release
Provides: %name-%old_theme_prefix-atlanta = %version-%release
Requires: %name = %version-%release

%description %theme_prefix-atlanta
This package contains a simple low-overhead default theme for Metacity.

%package %theme_prefix-bright
Summary: Metacity theme - Bright
Group: Graphical desktop/GNOME
BuildArch: noarch
Provides: %name-theme = %version-%release
Obsoletes: %name-%old_theme_prefix-bright = %version-%release
Provides: %name-%old_theme_prefix-bright = %version-%release
Requires: %name = %version-%release

%description %theme_prefix-bright
This package contains a simple theme based on Havoc Pennington's Atlanta.

%package %theme_prefix-crux
Summary: Metacity theme - Crux
Group: Graphical desktop/GNOME
BuildArch: noarch
Provides: %name-theme = %version-%release
Obsoletes: %name-%old_theme_prefix-crux = %version-%release
Provides: %name-%old_theme_prefix-crux = %version-%release
Requires: %name = %version-%release

%description %theme_prefix-crux
This package contains a port of the Crux theme by Arlo Rose and John
Harper.

%package %theme_prefix-esco
Summary: Metacity theme - Esco
Group: Graphical desktop/GNOME
BuildArch: noarch
Provides: %name-theme = %version-%release
Obsoletes: %name-%old_theme_prefix-esco = %version-%release
Provides: %name-%old_theme_prefix-esco = %version-%release
Requires: %name = %version-%release

%description %theme_prefix-esco
This package contains a simple theme designed to look really good match
GTK+ well.

%package %theme_prefix-gorilla
Summary: Metacity theme - AgingGorilla
Group: Graphical desktop/GNOME
BuildArch: noarch
Provides: %name-theme = %version-%release
Obsoletes: %name-%old_theme_prefix-gorilla = %version-%release
Provides: %name-%old_theme_prefix-gorilla = %version-%release
Requires: %name = %version-%release

%description %theme_prefix-gorilla
This package contains a port of the Gorilla theme by Jacub Steiner

%package %theme_prefix-metabox
Summary: Metacity theme - Metabox
Group: Graphical desktop/GNOME
BuildArch: noarch
Provides: %name-theme = %version-%release
Obsoletes: %name-%old_theme_prefix-metabox = %version-%release
Provides: %name-%old_theme_prefix-metabox = %version-%release
Requires: %name = %version-%release

%description %theme_prefix-metabox
This package contains a theme that looks a little like BlackBox.

%package %theme_prefix-simple
Summary: Metacity theme - Simple
Group: Graphical desktop/GNOME
BuildArch: noarch
Provides: %name-theme = %version-%release
Obsoletes: %name-%old_theme_prefix-simple = %version-%release
Provides: %name-%old_theme_prefix-simple = %version-%release
Requires: %name = %version-%release

%description %theme_prefix-simple
This package contains default GNOME window theme. It based on Atlanta
theme.

%prep
%setup -q
%patch4 -p1 -b .stop-spamming-xsession-errors
%patch5 -p1 -b .dnd-keynav
%patch16 -p1 -b .focus-different-workspace
%patch18 -p1 -b .focus-on-motion
%patch19 -p1 -b .no-focus-windows
%patch119 -p1 -b .no-focus-windows-current-app
%patch20 -p1 -b .always-on-top
%patch120 -p1 -b .always-on-top-activate
%patch24 -p1 -b .empty-keybindings
%patch25 -p1 -b .xioerror-unknown-display
%patch28 -p1 -b .grab-tracking
%patch29 -p1 -b .mouse-unmaximize

%build
%autoreconf
%configure \
    %{subst_enable compositor} \
    %{subst_enable render} \
    %{subst_enable shape} \
    %{subst_enable static} \
    --enable-sm \
    --enable-startup-notification \
    --enable-xsync \
    --enable-xinerama \
    --disable-schemas-compile

%make_build

%install
%make_install DESTDIR=%buildroot install

%find_lang  --with-gnome %name creating-%name-themes --output=%name.lang

%files -f %name.lang
%_bindir/*
%_datadir/%name
%_desktopdir/*
%_datadir/gnome/wm-properties/*.desktop
%_datadir/gnome-control-center/keybindings/50-metacity*.xml
%_datadir/glib-2.0/schemas/org.gnome.metacity.gschema.xml
%_datadir/GConf/gsettings/metacity-schemas.convert
%_man1dir/*
%doc README AUTHORS NEWS

%files -n lib%name
%_libdir/*.so.*

%files -n lib%name-devel
%_includedir/*
%_libdir/*.so
%_pkgconfigdir/*
%doc doc/*.txt doc/*.dtd HACKING

%if_enabled static
%files -n lib%name-devel-static
%_libdir/*.a
%endif

%files %{theme_prefix}s-default

%files %theme_prefix-gorilla
%_datadir/themes/AgingGorilla/*

%files %theme_prefix-atlanta
%_datadir/themes/Atlanta/*

%files %theme_prefix-bright
%_datadir/themes/Bright/*

%files %theme_prefix-crux
%_datadir/themes/Crux/*

%files %theme_prefix-esco
%_datadir/themes/Esco/*

%files %theme_prefix-metabox
%_datadir/themes/Metabox/*

%files %theme_prefix-simple
%_datadir/themes/Simple/*

%changelog
