Name: midori
Version: 0.5.11
Release: alt2%ubt

Summary: Lightweight web browser
License: LGPL
Group: Networking/WWW
Url: http://www.midori-browser.org/

# https://launchpad.net/midori
Source: https://launchpad.net/%name/trunk/%version/+download/%name-%version.tar.bz2
Patch1: midori-alt-providers.patch
Patch2: repair-build-errors.patch

BuildRequires(pre): rpm-macros-cmake rpm-build-ubt
BuildRequires: cmake gcc-c++ gcr-libs-devel intltool libnotify-devel
BuildRequires: librsvg-utils libsoup-gnome-devel libsqlite3-devel
BuildRequires: libtool_2.4 libxml2-devel libXScrnSaver-devel
BuildRequires: libunique-devel libwebkitgtk2-devel vala

%description
Midori is a lightweight web browser.
 * Full integration with GTK+2
 * Fast rendering with WebKit
 * Tabs, windows and session management
 * Flexibly configurable Web Search
 * User scripts and user styles support
 * Straightforward bookmark management
 * Customizable and extensible interface
 * Extensions such as Adblock, form history, mouse gestures or
   cookie management

%prep
%setup
%patch1 -p1
%patch2 -p1

%build
%cmake  -DCMAKE_BUILD_TYPE:STRING="Release" \
        -DHALF_BRO_INCOM_WEBKIT2:BOOL=OFF \
        -DUSE_GRANITE:BOOL=OFF \
        -DUSE_ZEITGEIST:BOOL=OFF
%cmake_build

%install
%cmakeinstall_std

%find_lang --with-gnome %name

%files -f %name.lang
%_sysconfdir/xdg/%{name}*
%_bindir/%name
%_libdir/%name
%_libdir/libmidori-core.so*
%_datadir/appdata/midori.appdata.xml
%_desktopdir/%name.desktop
%_desktopdir/%name-private.desktop
%_datadir/%name
%_iconsdir/hicolor/*/apps/*
%_iconsdir/hicolor/*/categories/*
%_iconsdir/hicolor/*/status/*
%_docdir/%name

%changelog
