%define debug_package %nil

Name: mingw32-filesystem
Version: 68
Release: alt1
Summary: MinGW base filesystem and environment

Group: Development/Other
License: GPLv2+
Url: http://hg.et.redhat.com/misc/fedora-mingw--devel/
BuildArch: noarch

Packager: Boris Savelev <boris@altlinux.org>

Source: COPYING
Source2: mingw32.sh
#Source3: mingw32.csh

BuildRequires: rpm-macros-mingw32

# Note about 'Provides: mingw32(foo.dll)'
# ------------------------------------------------------------
#
# We want to be able to build & install mingw32 libraries without
# necessarily needing to install wine.  (And certainly not needing to
# install Windows!)  There is no requirement to have wine installed in
# order to use the mingw toolchain to develop software (ie. to
# compile more stuff on top of it), so why require that?
#
# So for expediency, this base package provides the "missing" DLLs
# from Windows.  Another way to do it would be to exclude these
# proprietary DLLs in our find-requires checking script - essentially
# it comes out the same either way.
#
Provides:       mingw32(advapi32.dll)
Provides:       mingw32(cfgmgr32.dll)
Provides:       mingw32(comctl32.dll)
Provides:       mingw32(comdlg32.dll)
Provides:       mingw32(crypt32.dll)
Provides:       mingw32(ddraw.dll)
Provides:       mingw32(dnsapi.dll)
Provides:       mingw32(dsound.dll)
Provides:       mingw32(gdi32.dll)
Provides:       mingw32(gdiplus.dll)
Provides:       mingw32(glu32.dll)
Provides:       mingw32(glut32.dll)
Provides:       mingw32(imm32.dll)
Provides:       mingw32(kernel32.dll)
Provides:       mingw32(mscoree.dll)
Provides:       mingw32(msdmo.dll)
Provides:       mingw32(msimg32.dll)
Provides:       mingw32(msvcrt.dll)
Provides:       mingw32(netapi32.dll)
Provides:       mingw32(odbc32.dll)
Provides:       mingw32(ole32.dll)
Provides:       mingw32(oleaut32.dll)
Provides:       mingw32(opengl32.dll)
Provides:       mingw32(rpcrt4.dll)
Provides:       mingw32(secur32.dll)
Provides:       mingw32(setupapi.dll)
Provides:       mingw32(shell32.dll)
Provides:       mingw32(shlwapi.dll)
Provides:       mingw32(user32.dll)
Provides:       mingw32(usp10.dll)
Provides:       mingw32(version.dll)
Provides:       mingw32(winmm.dll)
Provides:       mingw32(wldap32.dll)
Provides:       mingw32(ws2_32.dll)
Provides:       mingw32(wsock32.dll)


%description
This package contains the base filesystem layout, RPM macros and
environment for all Fedora MinGW packages.

This environment is maintained by the Fedora MinGW SIG at:

  http://fedoraproject.org/wiki/SIGs/MinGW


%prep
%setup -q -c -T
cp %SOURCE0 COPYING

%build
# nothing


%install
mkdir -p %buildroot

mkdir -p %buildroot%_sysconfdir/profile.d
install -m 644 %SOURCE2 %buildroot%_sysconfdir/profile.d/
# install -m 644 {SOURCE3} %buildroot%_sysconfdir/profile.d/

# GCC requires these directories, even though they contain links
# to binaries which are also installed in /usr/bin etc.  These
# contain Fedora native binaries.
mkdir -p %buildroot%prefix/%_mingw32_target/bin
mkdir -p %buildroot%prefix/%_mingw32_target/lib

# The MinGW system root which will contain Windows native binaries
# and Windows-specific header files, pkgconfig, etc.
mkdir -p %buildroot%prefix/%_mingw32_target/sys-root/mingw
mkdir -p %buildroot%prefix/%_mingw32_target/sys-root/mingw/bin
mkdir -p %buildroot%prefix/%_mingw32_target/sys-root/mingw/include
mkdir -p %buildroot%prefix/%_mingw32_target/sys-root/mingw/include/sys
mkdir -p %buildroot%prefix/%_mingw32_target/sys-root/mingw/lib
mkdir -p %buildroot%prefix/%_mingw32_target/sys-root/mingw/lib/pkgconfig
mkdir -p %buildroot%prefix/%_mingw32_target/sys-root/mingw/sbin

mkdir -p %buildroot%prefix/%_mingw32_target/sys-root/mingw/share/aclocal
mkdir -p %buildroot%prefix/%_mingw32_target/sys-root/mingw/share/cmake
mkdir -p %buildroot%prefix/%_mingw32_target/sys-root/mingw/share/pkgconfig
mkdir -p %buildroot%prefix/%_mingw32_target/sys-root/mingw/share/xml

# We don't normally package manual pages and info files, except
# where those are not supplied by a Fedora native package.  So we
# need to create the directories.
#
# Note that some packages try to install stuff in
#   /usr/%_mingw32_target/sys-root/mingw/man and
#   /usr/%_mingw32_target/sys-root/mingw/doc
# but those are both packaging bugs.
mkdir -p %buildroot%prefix/%_mingw32_target/sys-root/mingw/share
mkdir -p %buildroot%prefix/%_mingw32_target/sys-root/mingw/share/doc
mkdir -p %buildroot%prefix/%_mingw32_target/sys-root/mingw/share/info
mkdir -p %buildroot%prefix/%_mingw32_target/sys-root/mingw/share/man
mkdir -p %buildroot%prefix/%_mingw32_target/sys-root/mingw/share/man/man{1,2,3,4,5,6,7,8,l,n}
mkdir -p %buildroot%prefix/%_mingw32_target/sys-root/mingw/share/themes

%files
%doc COPYING
%config(noreplace) %_sysconfdir/profile.d/mingw32.sh
#%config(noreplace) %_sysconfdir/profile.d/mingw32.csh
%prefix/%_mingw32_target

%changelog
