%global __strip %_mingw32_strip
%global __objdump %_mingw32_objdump

Summary: MinGW Windows port of the LibTIFF library
Name: mingw32-libtiff
Version: 3.8.2
Release: alt1
License: libtiff
Group: System/Libraries
Url: http://www.remotesensing.org/libtiff/

Packager: Boris Savelev <boris@altlinux.org>

Source: ftp://ftp.remotesensing.org/pub/libtiff/tiff-%version.tar.gz
Patch: tiffsplit-overflow.patch
Patch1: libtiff-3.8.2-ormandy.patch
Patch2: libtiff-3.8.2-CVE-2006-2193.patch
Patch4: libtiff-3.8.2-lzw-bugs.patch

Patch100: libtiff-mingw32-libjpeg-7-compatibility.patch

BuildArch: noarch

BuildRequires: mingw32-zlib mingw32-libjpeg
BuildRequires: rpm-build-mingw32
BuildRequires: mingw32-gcc
BuildRequires: mingw32-gcc-c++
BuildRequires: mingw32-binutils

%description
The libtiff package contains a library of functions for manipulating
TIFF (Tagged Image File Format) image format files.  TIFF is a widely
used file format for bitmapped images.  TIFF files usually end in the
.tif extension and they are often quite large.

The libtiff package should be installed if you need to manipulate TIFF
format image files.

%package static
Summary: Static version of the MinGW Windows LibTIFF library
Requires: %name = %version-%release
Group: System/Libraries

%description static
Static version of the MinGW Windows LibTIFF library.

%prep
%setup -q -n tiff-%version

# Patches from the native Fedora package:
%patch0 -p1 -b .overflow
%patch1 -p1 -b .ormandy
%patch2 -p1 -b .CVE-2006-2193
%patch4 -p1

# MinGW specific patches
# build with old libjpeg due wxGTK be ready
#patch100 -p0

%build
export MINGW32_CFLAGS="%_mingw32_cflags -fno-strict-aliasing"
%_mingw32_configure --enable-static --enable-shared
%make_build

%install
%makeinstall_std

# remove docs
rm -rf %buildroot%_mingw32_datadir/doc
rm -rf %buildroot%_mingw32_mandir

# remove binaries
rm -f %buildroot%_mingw32_bindir/*.exe

%files
%doc COPYRIGHT README RELEASE-DATE VERSION TODO ChangeLog
%_mingw32_bindir/libtiff-3.dll
%_mingw32_bindir/libtiffxx-3.dll
%_mingw32_includedir/*
%_mingw32_libdir/libtiff.dll.a
%_mingw32_libdir/libtiffxx.dll.a
%_mingw32_libdir/libtiff.la
%_mingw32_libdir/libtiffxx.la

%files static
%_mingw32_libdir/libtiff.a
%_mingw32_libdir/libtiffxx.a

%changelog
