%global __strip %_mingw32_strip
%global __objdump %_mingw32_objdump

%define wxbranch 2.8
%define ucode u
%define oname wxGTK
%def_enable unicode

%if_disabled unicode
%define ucode %{-E}
%endif

Name: mingw32-wxGTK
Version: 2.8.10
Release: alt5

Summary: The GTK+ port of the wxWidgets library
License: wxWidgets License
Group: System/Libraries
Url: http://wxwidgets.org

Packager: Boris Savelev <boris@altlinux.org>

Source: %oname-%version.tar.gz
Source2: ld_shared_wrapper.pl
Patch: changeset_r60875.diff
Patch1: changeset_r60876.diff
#Source: %name-2007-01-31.tar.bz2

BuildArch: noarch

# Automatically added by buildreq on Sat Sep 19 2009
BuildRequires: mingw32-dlfcn mingw32-gcc-c++ mingw32-libjpeg mingw32-libpng mingw32-pthreads mingw32-SDL
BuildRequires: rpm-build-mingw32 mingw32-libtiff mingw32-expat

%description
wxWidgets is a free C++ library for cross-platform GUI development.
With wxWidgets, you can create applications for different GUIs
(GTK+, Motif/LessTif, MS Windows, Mac) from the same source code.

This is a GTK+ port.

%package static
Summary: wxWidgets static library
Group: System/Libraries
Requires: %name = %version-%release

%description static
wxWidgets static librarary

%package debug
Summary: wxWidgets debug library
Group: System/Libraries
Requires: %name = %version-%release

%description debug
wxWidgets debug librarary

%package static-debug
Summary: wxWidgets static static library
Group: System/Libraries
Requires: %name = %version-%release

%description static-debug
wxWidgets static debug librarary

%prep
%setup -q -n %oname-%version
%__subst "s,bakefile/presets,bakefile/presets-\$(WX_RELEASE),g" Makefile.in
%patch0 -p0
%patch1 -p0

%build
#========= Shared Libraries ==========
for dist in shared_release shared_debug static_release static_debug ; do
    case $dist in
	shared_release)
	    CONF_FLAG="--enable-shared --without-debug_flag --without-debug_info"
	;;
	shared_debug)
	    CONF_FLAG="--enable-shared --enable-debug"
	;;
	static_release)
	    CONF_FLAG="--disable-shared --without-debug_flag --without-debug_info"
	;;
	static_debug)
	    CONF_FLAG="--disable-shared --enable-debug"
	;;
    esac

mkdir $dist && cd $dist
%_mingw32_configure $CONF_FLAG \
	--with-msw \
	--with-sdl \
	--enable-unicode \
	--enable-optimise \
	--with-regex=yes \
	--disable-rpath \
	--without-subdirs \
	--without-odbc \
	--without-opengl \
	--disable-joystick \
	--enable-plugins \
	--enable-precomp-headers=yes \
	--enable-compat26 \
	--enable-gtk2=yes \
	--enable-soname \
	--without-gnomeprint

%make_build SHARED_LD_CXX='perl %SOURCE2 $(CXX) -shared -fPIC -o'
cd ..
done

%install
for dist in shared_release shared_debug static_release static_debug ; do
%makeinstall_std -C $dist
done
if ls %buildroot%_mingw32_libdir/*.dll ; then
  mv %buildroot%_mingw32_libdir/*.dll %buildroot%_mingw32_bindir
else
  echo "No shared libraries found."
fi

# we need to modify the absolute wx-config link to be relative or rpm complains
# (and our package wouldn't be relocatable)
wx_config_filename=$(basename %buildroot%_mingw32_libdir/wx/config/%_mingw32_target-*-release-[0-9]*)
ln -sf ../lib/wx/config/$wx_config_filename %buildroot%_mingw32_bindir/wx-config

rm -rf %buildroot%_mingw32_datadir/bakefile

%files
%doc docs/*
%_mingw32_bindir/wx-config
%_mingw32_bindir/wx*28u_*.dll
%_mingw32_libdir/wx
%exclude %_mingw32_libdir/wx/config/%_mingw32_target-*-static-*
%exclude %_mingw32_libdir/wx/config/%_mingw32_target-*-debug-*
%_mingw32_includedir/wx-%wxbranch
%_mingw32_datadir/aclocal/*.m4

%files static
%_mingw32_libdir/libwx*u_*.dll.a
%_mingw32_libdir/libwx*u-*.a
%_mingw32_libdir/libwx*u_*.a
%_mingw32_libdir/wx/config/%_mingw32_target-*-static-*
%exclude %_mingw32_libdir/wx/config/%_mingw32_target-*-debug-*

%files debug
%_mingw32_bindir/wx*28ud_*.dll
%_mingw32_libdir/wx/config/%_mingw32_target-*-debug-*
%exclude %_mingw32_libdir/wx/config/%_mingw32_target-*-static-*

%files static-debug
%_mingw32_libdir/libwx*ud_*.dll.a
%_mingw32_libdir/libwx*ud-*.a
%_mingw32_libdir/libwx*ud_*.a
%_mingw32_libdir/wx/config/%_mingw32_target-*-static-*
%exclude %_mingw32_libdir/wx/config/%_mingw32_target-*-release-*

%changelog
