%def_enable static
%def_with quicktime

%define oname mjpegtools
Name: %{oname}1.9
Version: 1.9.0
Release: alt6.qa2

Summary: Tools for recording, editing, playing back mpeg-encoding video under linux
License: GPL
Group: Video
Url: http://mjpeg.sourceforge.net
Packager: Pavlov Konstantin <thresh@altlinux.ru>

Source: http://prdownloads.sourceforge.net/mjpeg/%name-%version.tar.gz
Patch4: 0003-Fix-path-to-transcode.patch
Patch5: 0001-Fix-build-with-new-gcc.patch
Patch6: mjpegtools-1.9.0-alt-v4l.patch
Patch7: mjpegtools-1.9.0-alt-libpng15.patch

%define quicktime_ver 0.9.7
%define libdv_ver 0.9

Requires: libquicktime >= %quicktime_ver
Requires: lib%oname = %version-%release 
Requires: libdv >= %libdv_ver

BuildPreReq: libquicktime-devel >= %quicktime_ver
BuildPreReq: libdv >= %libdv_ver

BuildRequires: glibc-kernheaders libjpeg-devel libSDL_gfx-devel gcc-c++
BuildRequires: libpng-devel libXxf86dga-devel libgtk+2-devel libSDL-devel
BuildRequires: libXt-devel libv4l-devel

#BuildRequires: libICE-devel libSDL-devel libSM-devel libX11-devel libXext-devel libXt-devel libXxf86dga-devel libatk-devel libcairo-devel libdv-devel libgtk+2-devel libpango-devel libpng-devel libquicktime-devel libstdc++-devel pkg-config xorg-cf-files xorg-x11-proto-devel zlib-devel libjpeg-mmx-devel
   
%description
The MJPEG-tools are a basic set of utilities for recording, editing,
playing back and encoding (to mpeg) video under linux. Recording can
be done with zoran-based MJPEG-boards (LML33, Iomega Buz, Pinnacle
DC10(+), Marvel G200/G400), these can also playback video using the
hardware. With the rest of the tools, this video can be edited and
encoded into mpeg1/2 or divx video.

%ifarch %ix86
NOTE:
The resultant binaries will ***NOT*** run on a K6 or Pentium CPU
%endif

%package -n lib%oname
Summary: Shared libraries for the mjpegtools
Group: System/Legacy libraries
Obsoletes: %name-libs
Provides: %name-libs = %version-%release

%description -n lib%oname
This package contains shared libraries needed to run mjpegtools.

%ifarch %ix86
NOTE:
This binaries does ***NOT*** compatible with a K6 or Pentium CPU
%endif

%package -n lib%name-devel
Summary: Development headers and libraries for the mjpegtools
Group: Development/C
Obsoletes: %name-devel
Provides: %name-devel = %version-%release
Requires: lib%oname = %version-%release

%description -n lib%name-devel
This package contains libraries and header files needed to compile
applications that use part of the libraries of the mjpegtools package.

%package -n lib%name-devel-static
Summary: Static libraries for the mjpegtools
Group: Development/C
Obsoletes: %name-static-libs
Provides: %name-static-libs = %version-%release
Requires: lib%name-devel = %version-%release

%description -n lib%name-devel-static
This package contains static libraries needed to compile applications
that use part of the libraries of the mjpegtools package.

%ifarch %ix86
NOTE:
This binaries does ***NOT*** compatible with a K6 or Pentium CPU
%endif

#set_verify_elf_method textrel=relaxed

%prep
%setup -q
%patch4 -p2
%patch5 -p2
%patch6 -p2
%patch7 -p2

%build
%configure \
	%{subst_enable static} \
	%{subst_with quicktime} \
	--enable-large-file \
%ifarch %ix86
	--enable-simd-accel
%endif

sed -ri 's/^(hardcode_libdir_flag_spec|runpath_var)=.*/\1=/' libtool
# SMP-incompatible build
%make

%install
%makeinstall

# remove non-packaged files
rm -f %buildroot%_infodir/dir

#files
#_bindir/*
#_man1dir/*
#_infodir/*.info*
#doc AUTHORS BUGS CHANGES HINTS PLANS README TODO

%files -n lib%oname
%_libdir/*.so.*

#files -n lib%name-devel
#_includedir/*
#_libdir/*.so
#_libdir/pkgconfig/*
#_man5dir/*

#files -n lib%name-devel-static
#_libdir/*.a

%changelog
