Name: mk-configure
Version: 0.29.1
Release: alt1

Summary: Lightweight replacement for GNU autotools
License: BSD
Group: Development/Tools

Url: http://sourceforge.net/projects/mk-configure/
# Source: http://prdownloads.sf.net/%name/%name-%version.tar
Source: %name-%version.tar.bz2
Packager: Aleksey Cheusov <cheusov@altlinux.org>

BuildArch: noarch

Requires:      bmake bmkdep
BuildRequires: bmake binutils

# required for tests
BuildRequires: flex bison gcc-c++ glib2-devel groff-base zlib-devel bmkdep
BuildRequires: perl-podlators perl-devel liblua5-devel info-install makeinfo m4

%description
mk-configure is a lightweight replacement for GNU autotools, written in
bmake (portable version of NetBSD make), POSIX shell and POSIX utilities.

%prep
%setup

%define env \
  unset MAKEFLAGS; \
  export PREFIX=%prefix MANDIR=%_mandir SYSCONFDIR=%_sysconfdir

# examples are built and tested either,
# let's keep a pristine copy
cp -al examples doc

%build
%env
bmake all

%install
%env
bmake install DESTDIR=%buildroot
rm -rf %buildroot%_docdir/%name

%check
unset MAKEFLAGS
# lua tests expect correct lua.pc
export NOSUBDIR='lua_dirs hello_lua hello_lua2 hello_lua3 hello_reqd'
# hello_libdeps was already fixed in upstream, for now we skip it too
export NOSUBDIR="$NOSUBDIR examples/hello_libdeps"
# /sbin/install-info
export PATH=/sbin:$PATH
bmake test

%files
%doc doc/FAQ doc/LICENSE doc/NEWS doc/NOTES README presentation/presentation.pdf
%doc doc/examples/
%_bindir/*
%_datadir/mk-configure/
%_datadir/mkc-mk/
%_man1dir/*
%_man7dir/*

%changelog
