Name: mkimage-profiles
Version: 1.2.25
Release: alt0.M80P.1

Summary: ALT based distribution metaprofile
License: GPLv2+
Group: Development/Other

Url: http://altlinux.org/m-p
Source: %name-%version.tar
Packager: Michael Shigorin <mike@altlinux.org>

BuildArch: noarch
BuildRequires: rsync

Requires: rsync git-core
Requires: time schedutils sfdisk
Requires: mkimage >= 0.2.5
Requires: mkimage-preinstall

# Recommends: graphviz qemu-img

%define mpdir %_datadir/%name
%add_findreq_skiplist %mpdir/*.in/*

%def_with doc
%define docs $HOME/docs

Summary(ru_RU.UTF-8): метапрофиль дистрибутивов на базе Альт

%description
mkimage-profiles is a collection of bits and pieces useful for
distributions construction: it contains package lists, features,
and whole subprofiles (like "rescue" building block) for you
to choose from, and some ready-made image recipes as well.

Make no mistake: constructing distributions isn't just fun, it takes
a lot of passion and knowledge to produce a non-trivial one.  So m-p
(the short alias for mkimage-profiles) is complex too.  If you need
-- or want -- to make a few tweaks to an existing recipe, it might
be easier to comprehend the generated profile (aka builddir) which
contains only the needed subprofiles, script hooks and package lists
and is way more compact.

The main deliverable form for x86 is a (hybrid) ISO; virtual environment
template caches (OpenVZ/LXC) can be made either as well as VM disk images.

In short, setup hasher (http://en.altlinux.org/hasher) and here we go:
  cd %mpdir
  head README
  make syslinux.iso

But if you're into regular distro hacking and are not afraid of make
and modest metaprogramming (some code generation and introspection),
welcome to the metaprofile itself; read the docs and get the git:
%url (NB: these are mostly in Russian with translation on demand).

%description -l ru_RU.UTF-8
mkimage-profiles является собранием всего необходимого для
построения дистрибутивов и содержит списки пакетов, особенности
и целые субпрофили (вроде "кирпичика" rescue), из которых можно
выбирать требуемое; также включены и описания готовых образов.

Поймите правильно: создание дистрибутивов является занятием
не только интересным, но и требующим вдохновения и знаний
для получения нетривиального результата.  Если хочется или же
необходимо чуток поправить уже существующий "рецепт", может
быть проще разобраться в сгенерированном профиле (builddir),
который содержит только необходимые субпрофили, скрипты
и списки пакетов, являясь намного более компактным.

Основной формой результата на x86 является (гибридный) ISO-образ;
также возможно создавать шаблоны контейнеров OpenVZ/LXC и образы
дисков виртуальных машин.

Короче говоря, настройте hasher (http://altlinux.org/hasher) и:
  cd %mpdir
  head README
  make syslinux.iso

Но если разработка дистрибутивов становится обыденным делом
и не страшитесь make и чуточки метапрограммирования (немного
генерирования кода и интроспекции), добро пожаловать в сам
метапрофиль; гляньте документацию и забирайте git:
%url

%package doc
Summary: %name documentation
Group: Development/Documentation
%{?_with_doc:BuildRequires: java /proc}
%{?_with_doc:BuildRequires: asciidoc-a2x fop fonts-ttf-dejavu}
Summary(ru_RU.UTF-8): документация %name

%description doc
This package holds developer docs for %name
as a book in HTML and PDF formats.

%description -l ru_RU.UTF-8 doc
Этот пакет содержит документацию разработчика
для %name в форме книжки (HTML, PDF).

%prep
%setup

%build
%if_with doc
make BUILDDIR=%docs docs
%endif

%install
mkdir -p %buildroot{%mpdir,%_man7dir}
cp -a * %buildroot%mpdir
%if_with doc
mv %buildroot%mpdir/doc/mkimage-profiles.7 %buildroot%_man7dir/
%endif

%files
%mpdir/
%if_with doc
%_man7dir/*
%endif

%if_with doc
%files doc
%doc README
%doc QUICKSTART
%doc %docs/*
%endif

%changelog
