%def_disable debug
%def_disable profiling

%def_enable gui
%def_enable bz2
%def_enable lzo
%def_disable wxwidgets
%def_enable qt
%def_with flac
%def_without tools

%undefine _configure_gettext

Name: mkvtoolnix
Version: 8.2.0
Release: alt1

Summary: Tools to create, alter and inspect Matroska files
License: GPL
Group: Video
URL: http://www.bunkus.org/videotools/%name/
Source: %{url}sources/%name-%version.tar

Provides: mkvmerge = %version-%release

BuildRequires(pre): rpm-build-xdg
BuildRequires: gcc-c++ boost-devel boost-filesystem-devel zlib-devel libmagic-devel
BuildRequires: libexpat-devel libvorbis-devel ImageMagick ruby ruby-stdlibs symlinks
BuildRequires: libcurl-devel libebml-devel >= 1.3.1 libmatroska-devel >= 1.4.2

%{?_enable_wxwidgets:BuildRequires: libpango-devel libwxGTK3.1-devel}
%{?_enable_qt:BuildRequires: qt5-base-devel}
%{?_enable_bz2:BuildRequires: bzlib-devel}
%{?_enable_lzo:BuildRequires: liblzo2-devel}
%{?_with_flac:BuildRequires: libflac-devel}

%description
Matroska is a new multimedia file format aiming to become the new
container format for the future.
With these tools one can extract tracks/data from (mkvextract) Matroska
files and create (mkvmerge) Matroska files from other media files.

%if_enabled gui
%package gui
Summary: GUI for mkvmerge including a chapter editor
License: GPL
Group: Video
Provides: mmg = %version-%release
Provides: mkvmerge-gui = %version-%release
Obsoletes: mkvmerge-gui

%description gui
Matroska is a new multimedia file format aiming to become the new
container format for the future.
mkvmerge GUI is a wxWindows based GUI for mkvmerge. It offers easy
access to all of mkvmerge's options. All settings (e.g. source files,
track options etc) can be saved and restored. Included is a chapter
editor that can read OGM style and XML style chapter files, write XML
style chapter files and even read chapters from Matroska files and
write chapters directly to Matroska files.
%endif

%package -n mkvinfo
Summary: Tool for print information about tracks in Matroska files
License: GPL
Group: Video

%description -n mkvinfo
Matroska is a new multimedia file format aiming to become the new
container format for the future.
With mkvinfo you can get information about Matroska files. This program
lists all tracks contained in a Matroska file including information
about the codecs used.

%if_with tools
%package tools
Summary: %name additional tools
Group: Video
Conflicts: %name < 2.4.0-alt1

%description tools
Matroska is a new multimedia file format aiming to become the new
container format for the future.
This package contains some additional tools.
%endif

%prep
%setup

%build
./autogen.sh
export LINGUAS="en ru uk"
%configure \
    --disable-option-checking \
    %{subst_enable debug} \
    %{subst_enable profiling} \
    %{subst_enable gui} \
    %{subst_enable bz2} \
    %{subst_enable lzo} \
    %{subst_enable wxwidgets} \
    %{subst_enable qt} \
    %{subst_with flac}

./drake %{?_with_tools:TOOLS=1} V=1

bzip2 --best --force --keep ChangeLog

%install
./drake DESTDIR=%buildroot install

mkdir -p %buildroot%_defaultdocdir/%name-%version
install -m0644 AUTHORS ChangeLog.* README.md %buildroot%_defaultdocdir/%name-%version
cp -ar examples %buildroot%_defaultdocdir/%name-%version

%if_with tools
install -m0755 -D src/tools/{base64tool,diracparser,ebml_validator,vc1parser} %buildroot%_bindir
%endif

%find_lang %name

%files -f %name.lang
%_bindir/mkvextract
%_bindir/mkvmerge
%_bindir/mkvpropedit
%_man1dir/mkvextract.*
%_man1dir/mkvmerge.*
%_man1dir/mkvpropedit.*
%_defaultdocdir/%name-%version

%files -n mkvinfo
%_bindir/mkvinfo
%_man1dir/mkvinfo.*
%_iconsdir/hicolor/*/apps/mkvinfo.*
%_datadir/applications/mkvinfo.desktop
%_desktopdir/mkvinfo.desktop

%if_enabled gui
%files gui
%_bindir/%name-gui
%_man1dir/%name-gui.*
%_iconsdir/hicolor/*/apps/%name-gui.*
%_desktopdir/%name-gui.desktop
%_xdgmimedir/packages/%name.xml
%endif

%if_with tools
%files tools
%_bindir/base64tool
%_bindir/*parser
%_bindir/ebml_validator
%endif

%changelog
