%def_disable gui
Name: mldonkey
Version: 3.1.0
Release: alt1.2

%define ml_ver %version

Group: Networking/File transfer
Summary: The eDonkey client for Linux/Unix/Windows
URL: http://mldonkey.sourceforge.net/
License: GPL
Source: http://savannah.nongnu.org/download/mldonkey/%name-%version.tar
Source1: mldonkey_client.sh
Source3: mldonkey_server.sh

Patch: alt-site-lib.patch
Patch1: mldonkey-3.1.0-alt-DSO.patch

# Automatically added by buildreq on Sat Sep 03 2005
BuildRequires: bzlib-devel camlp4 fontconfig libfreetype-devel glib2-devel libatk-devel libgd2-devel libjpeg-devel libncurses-devel libpango-devel libpng12-devel librsvg-devel libXpm-devel ocaml-runtime pkgconfig wget zlib-devel
%if_enabled gui
BuildRequires: lablgtk2 libgtk+2-devel
%endif
# for mldonkey-submit
BuildRequires(pre): perl-libwww-perl

Conflicts: mldonkey-client
Provides: mldonkey-server
Obsoletes: mldonkey-client
Obsoletes: mldonkey-server

%description
MLDonkey - the Open Source eDonkey client
features:
* 100%% OpenSource, GPL license
* runs on Linux, Unix, Solaris, MacOSX, MorphOS and Windows
* Core and Guis are separated or linked.
* written in ObjectiveCaml, with some C and even some Assembler parts.
* OtherNetworksSupported, using separate executables
* built to run as daemon for days, weeks, ever... 

MLdonkey is a peer-to-peer file-sharing client completely written 
in Objective-Caml, that can be used to access the eDonkey2000, 
BitTorrent, Overnet, Direct Connect and Soulseek networks. It supports
downloads from multiple sources and corruption detection, complex search
requests, chat with friends, internationalization, history of search results,
etc...

%if_enabled gui
%package client
Group: Networking/File transfer
Summary: Graphical frontend for mldonkey based on GTK
License: GPL

%description client
The GTK interface for mldonkey provides a convenient way of managing            
all mldonkey operations. It gives details about conected servers,               
downloaded files, friends and lets one search for files in a pleasing           
way.
%endif

%prep
%setup -q
%patch -p2
%patch1 -p2

%build
cd config
autoconf
cd ../
./configure --enable-largefile \
	    %if_enabled gui
	     --enable-gui
	    %endif
#
%make_build
%__make make_torrent

%install
%__mkdir_p %buildroot%_bindir
%if_enabled gui
%__mkdir_p %buildroot%_datadir/%name
%__mkdir_p %buildroot%_niconsdir
%__mkdir_p %buildroot%_liconsdir
%__mkdir_p %buildroot%_miconsdir
%endif

%__install -pD -m755 mlnet %buildroot%_bindir/mlnet
%__install -pD -m755 %SOURCE3 %buildroot%_bindir/mldonkey_server
%__install -pD -m755 make_torrent %buildroot%_bindir/mldonkey_make_torrent

%if_enabled gui
cp -R distrib/* %buildroot%_datadir/%name
%__install -pD -m755 mlnet+gui %buildroot%_bindir/mlnet+gui
%__install -pD -m755 mlgui %buildroot%_bindir/mlgui
%__install -pD -m755 %SOURCE1 %buildroot%_bindir/mldonkey_client
%__install -pD -m755 mlguistarter %buildroot%_bindir/mlguistarter
%__install -pD -m755 distrib/mldonkey_previewer %buildroot%_bindir/mldonkey_previewer

## menu ##
%__install -p -m644 packages/rpm/%name-icon-16.png %buildroot/%_niconsdir/%name.png
%__install -p -m644 packages/rpm/%name-icon-32.png %buildroot/%_miconsdir/%name.png
%__install -p -m644 packages/rpm/%name-icon-48.png %buildroot/%_liconsdir/%name.png

mkdir -p %buildroot%_desktopdir
cat > %buildroot%_desktopdir/%{name}.desktop <<EOF
[Desktop Entry]
Version=1.0
Type=Application
Name=eDonkey2000
Comment=Door to the 'donkey' network
Icon=%{name}
Exec=%{name}_client
Terminal=false
Categories=Network;FileTransfer;
EOF
%endif

%files
%_bindir/mlnet
%_bindir/mldonkey_server
%_bindir/mldonkey_make_torrent

%if_enabled gui
%files client
%_bindir/mlgui
%_bindir/mlnet+gui
%_bindir/mldonkey_client
%_bindir/mlguistarter
%_bindir/mldonkey_previewer
%_datadir/%name
%exclude %_datadir/%name/ed2k_mozilla
%_desktopdir/%{name}.desktop
%_niconsdir/%name.png
%_miconsdir/%name.png
%_liconsdir/%name.png
%endif

%changelog
