#define beta _beta7
%define beta %nil
%def_enable optimized
%def_with pam

Name: monit
Version: 5.17.1
Release: alt3

Summary: Process monitor and restart utility
License: AGPLv3
Group: Monitoring

Url: http://mmonit.com/monit
Source0: %url/dist/%name-%version%beta.tar.gz
Source1: %name.sysconfig
Source2: monit.init
Source3: monitrc
Source4: %name.cnf
Source5: README.Certificate-Creation
Source6: monitrc.d.tar.gz
Source100: monit.watch
Packager: Michael Shigorin <mike@altlinux.org>

PreReq: openssl
Requires(post,preun): chkconfig
Requires: %name-base = %version-%release
Requires(post,preun): service >= 0.5-alt1

# Automatically added by buildreq on Fri Apr 06 2012
# optimized out: libcom_err-devel libkrb5-devel
BuildRequires: flex libpam-devel libssl-devel

%define _ssldir %_var/lib/ssl
%define _pemdir %_ssldir/certs

Summary(ru_RU.UTF-8): Утилита для мониторинга запущенных процессов
Summary(uk_UA.UTF-8): Утиліта для моніторингу процесів у системі

%package base
Summary: Directory for monit configuration files
Summary(ru_RU.UTF-8): Каталог для конфигурационных файлов monit
Summary(uk_UA.UTF-8): Тека для конфігураційних файлів monit
Group: System/Servers
Provides: /etc/monitrc.d
BuildArch: noarch

%description
monit is an utility for monitoring services or similar programs running on
a Unix system. It will start specified programs if they are not running
and restart programs not responding.  Many checks can be performed:
  - process existence
  - connectability
  - protocol-level (SMTP,POP3,IMAP,NNTP,HTTP,SSH,FTP,SIP)
  - resource usage (cpu/ram)
  - process interdependencies

%description -l ru_RU.UTF-8
Monit предназначен для слежения за выполнением процессов (обычно сервисов),
запущенных в системе UNIX. Monit может следить за несколькими параметрами:
  - существование процесса
  - возможность установления соединения(ий)
  - работоспособность протокола (SMTP,POP3,IMAP,NNTP,HTTP,SSH,FTP,SIP)
  - использование процессом памяти и вычислительных ресурсов
  - зависимости между процессами

%description -l uk_UA.UTF-8
Monit застосовується для стеження за виконанням процесів (зазвичай сервісів),
що запущені у системі UNIX. Monit може слідкувати за декількома параметрами:
  - існування процесу
  - можливість встановлення з'єднання
  - роботоздатність протоколу (SMTP,POP3,IMAP,NNTP,HTTP,SSH,FTP,SIP)
  - використання процесом пам'яті та обчислювальних ресурсів
  - залежності між процесами

%description base
Directory for monit configuration files

%description -l ru_RU.UTF-8 base
Каталог для конфигурационных файлов monit

%description -l uk_UA.UTF-8 base
Тека для конфігураційних файлів monit

%prep
%setup -n %name-%version%beta
sed -i \
	-e 's,allow localhost,use address 127.0.0.1,' \
	-e 's,admin:monit,monit:secretword,' monitrc

%build
sh bootstrap
%autoreconf
%configure \
	%{subst_with pam}

%make_build

%install
%makeinstall_std

# see also #27990
install -pD %buildroot{%_bindir,/bin}/monit
ln -sf ../../bin/monit %buildroot%_bindir/monit

mkdir -p %buildroot%_sysconfdir/sysconfig/
install -pDm644 %SOURCE1 %buildroot%_sysconfdir/sysconfig/%name

cat %SOURCE3 >>monitrc
install -pDm755 %SOURCE2  %buildroot%_initdir/%name
install -pDm600 monitrc %buildroot%_sysconfdir/monitrc
install -pDm644 %SOURCE4  %buildroot%_ssldir/%name.cnf

#mkdir -p %buildroot%_sysconfdir/monitrc.d/available/
mkdir -p %buildroot%_sysconfdir/monitrc.d/
mkdir -p %buildroot%_pemdir
touch %buildroot%_pemdir/%name.pem

tar xpf %SOURCE6
cp -a monitrc.d/templates/ %buildroot%_sysconfdir/monitrc.d/
mv monitrc.d examples
ln -s %_docdir/%name-%version/examples %buildroot%_sysconfdir/monitrc.d/EXAMPLES
ln -s monitrc.d %buildroot%_sysconfdir/monit.d

%post
cd %_pemdir
if [ ! -f %name.pem ]; then
	umask 077
	echo -e '\n.\n.\n.\n.\n.\n' |
	openssl req -newkey rsa:1024 -x509 -days 365 -nodes \
		-config %_ssldir/%name.cnf \
		-keyout %name.pem -out %name.pem &>/dev/null
fi

grep -qs '^    allow localhost ' /etc/monitrc && {
  echo "** WARNING: replace 'allow localhost' with 'use address 127.0.0.1'"
  echo "            in /etc/monitrc"; } >&2 ||:

grep -qs '^    allow admin:monit ' /etc/monitrc && {
  echo "** WARNING: replace 'allow admin:monit' with another login:password"
  echo "            in /etc/monitrc"; } >&2 ||:

if ! grep -qs '^set pidfile ' /etc/monitrc /etc/monitrc.d/*; then
  echo "** WARNING: adding 'set pidfile /var/run/monit.pid' to /etc/monitrc" >&2
  {
    echo
    echo "# added by monit-5.17.1-alt3 package upgrade"
    echo "set pidfile /var/run/monit.pid"
  } >> /etc/monitrc
fi

%post_service %name

%preun
%preun_service %name

%files
%doc README* examples/
%config %_initdir/%name
%ghost %attr(600,root,root) %config(noreplace,missingok) %_pemdir/*
%dir %_sysconfdir/monitrc.d/templates/
%config(noreplace) %_sysconfdir/monitrc.d/templates/*
%config(noreplace) %_sysconfdir/monitrc
%config(noreplace) %_ssldir/%name.cnf
%config(noreplace) %_sysconfdir/sysconfig/%name
%_sysconfdir/monitrc.d/EXAMPLES
%_sysconfdir/monit.d
%_man1dir/%name.1.*
%_bindir/%name
/bin/monit

%files base
%dir %_sysconfdir/monitrc.d
#dir %_sysconfdir/monitrc.d/available

# TODO:
# - move to cert-sh-functions for certificate generation?
# - add rsync, oracle tns config snippets (proto checks present)
# - each "check file" += "every 48 cycles"

%changelog
