%define _unpackaged_files_terminate_build 1

%def_disable check

Name: monotone
Version: 1.2
Release: alt4.M80P.1.dev.mtn20150211

Summary: Distributed version control system
License: GPL
Group: Development/Tools

Url: http://monotone.ca

# get: mtn clone mtn://code.monotone.ca/monotone?net.venge.monotone
# update: mtn pull --update
Source: %name-%version.tar

Patch1: %name-1.1-fedora-pcre.patch

BuildRequires: pcre-devel boost-devel libbotan-devel pkg-config
BuildRequires: libidn-devel lua-devel libsqlite3-devel texinfo
BuildRequires: zlib-devel gcc-c++

%description
monotone is a free, distributed version control system. It provides
fully disconnected operation, manages complete tree versions, keeps
its state in a local transactional database, supports overlapping
branches and extensible metadata, exchanges work over plain network
protocols, performs history-sensitive merging, and delegates trust
functions to client-side RSA certificates.

%prep
%setup
%patch1 -p1

rm -fR Attic/botan

%build
%autoreconf
%add_optflags -std=gnu++11
%add_optflags -DBOOST_DISABLE_ASSERTS=1 -DBOOST_ENABLE_ASSERT_HANDLER
export CPPFLAGS="%optflags"
%configure --enable-ipv6
%make_build

%check
DISABLE_NETWORK_TESTS=1 make check

%install
%makeinstall

# consider packing it when bash4 becomes default - see bug #30775
rm -rf %buildroot%_sysconfdir/bash_completion.d

%find_lang %name

%files -f %name.lang
%_bindir/*
%_infodir/*
%_man1dir/*
%_datadir/%name
%doc %_docdir/%name
%doc AUTHORS NEWS README UPGRADE HACKING INSTALL ChangeLog notes/*

%changelog
