# vim: set ft=spec: -*- rpm-spec -*-

# %%branch_switch set %%branch_release use
#%%define branch_switch Mxx

%define packagversion 1.9.19
%define packagedate 20130513
%define packagemoodleversion 2007101592.05
%define moodlebranch %nil
%define moodlepackagename %moodle_name%moodlebranch

#Name: %moodlepackagename
Name: moodle
Version: %packagversion.%packagedate
Release: %branch_release alt1

Summary: The Course Management System Moodle
License: %gpl2plus
Group: Networking/WWW

Url: http://www.moodle.org
Packager: Aleksey Avdeev <solo@altlinux.ru>
BuildArch: noarch

Source: %name-%version.tar
Source10: %moodle_name.httpd.conf
Source20: %moodle_name.httpd2.conf
Source21: %moodle_name.start.extra.conf
Source22: %moodle_name.start.mods.conf
Source23: %moodle_name.httpd2.inc.conf

Patch1: %name-alt-install-directorypermissions.patch
Patch2: %name-alt-install-datadir-fix.patch

Requires: %name-base = %version-%release
Requires: %name-auth-pam >= 1.9.19.2007101592.04.0.20130114-alt1
Requires: %name-mod-journal >= 1.9.19.20130114-alt1
Requires: %name-mod-hotpot >= 2.4.13.2007101513.0.20130114-alt1

BuildRequires(pre): rpm-macros-branch
BuildRequires(pre): rpm-macros-moodle >= 2.4
BuildRequires(pre): rpm-macros-apache2
BuildPreReq: rpm-macros-fonts
BuildPreReq: rpm-build-webserver-common
BuildPreReq: rpm-build-licenses
BuildPreReq: perl-HTML-Parser

%description
Moodle is a course management system (CMS) - a free, Open Source software
package designed using sound pedagogical principles, to help educators create
effective online learning communities.

This package, with dependencies, install all the standard components
of Moodle.

%package base
Summary: Base part for Moodle CMS
Group: Networking/WWW

PreReq: webserver-common
PreReq: %_sbindir/web-condstop-rpm
PreReq: %_sbindir/web-condstart-rpm
PreReq: %_sbindir/mt-getCFG
PreReq: %_sbindir/mt-setCFG
PreReq: %_sbindir/mt-newdatadir
Requires: %webserver_webappsdir
Requires: php-engine php5-gd2 php5-openssl php5-xmlrpc php5-curl iconv php5-mbstring php5-ldap
Requires: texlive-base-bin ImageMagick
Provides: %moodle_dir
Provides: %moodle_admindir
Provides: %moodle_authdir
Provides: %moodle_blocksdir
Provides: %moodle_calendardir
Provides: %moodle_coursedir
Provides: %moodle_docdir
Provides: %moodle_enroldir
Provides: %moodle_filesdir
Provides: %moodle_filterdir
Provides: %moodle_langdir
Provides: %moodle_libdir
Provides: %moodle_logindir
Provides: %moodle_moddir
Provides: %moodle_pixdir
Provides: %moodle_questiondir
Provides: %moodle_questionformatdir
Provides: %moodle_themedir
Provides: %moodle_datadir
Provides: %moodle_name-version = %packagemoodleversion
Provides: moodle-lang-en_utf8 = %version-%release
Obsoletes: moodle-lang-en_utf8 < %version-%release
Conflicts: moodle-apache2 <= 1.9.10-alt2.cvs20101110
Conflicts: moodle-apache2 >= 2.0
Conflicts: moodle-lang >= 2.0
Conflicts: moodle-local-mysql >= 2.0
Conflicts: %moodle_name >= 2.0
Conflicts: %moodle_name-appfor >= 2.0
# Old moodle-lang-*
Conflicts: moodle-lang-be_utf8 < 1.9.10.20100526
Conflicts: moodle-lang-de_utf8 < 1.9.10.20110705
Conflicts: moodle-lang-es_utf8 < 1.9.10.20101112
Conflicts: moodle-lang-fr_utf8 < 1.9.10.20110718
Conflicts: moodle-lang-hy_utf8 < 1.9.10.20100526
Conflicts: moodle-lang-it_utf8 < 1.9.10.20110319
Conflicts: moodle-lang-ja_utf8 < 1.9.10.20110809
Conflicts: moodle-lang-pt_utf8 < 1.9.10.20100814
Conflicts: moodle-lang-ru_utf8 < 1.9.10.20100617
Conflicts: moodle-lang-uk_utf8 < 1.9.10.20100526
Conflicts: moodle-lang-uz_utf8 < 1.9.10.20100526
Conflicts: moodle-lang-zh_tw_utf8 < 1.9.10.20100526
Conflicts: moodle-lang-zh_cn_utf8 < 1.9.10.20100526

%description base
%summary

Part of the standard components of Moodle, is not included
in this package is moved to subpackages.

#%package apache
#Summary: apache-related config for Moodle CMS
#Group: Networking/WWW
#Requires: %name = %version-%release
#Requires: apache apache-mod_php5

#%description apache
#%summary

%package apache2
Summary: apache2-related config for Moodle CMS
Group: Networking/WWW
Requires: apache2-base > 2.2.17-alt2
Requires: %apache2_extra_available
Requires: %apache2_extra_enabled
Requires: %apache2_extra_start
Requires: %apache2_mods_start
Requires: %apache2_confdir_inc
Requires: %name-base < 2.0
Requires: %moodle_dir
Requires: %moodle_datadir
Requires: apache2-mod_php5
Conflicts: %moodle_name >= 2.0
Conflicts: %moodle_name-base >= 2.0

%description apache2
%summary

%package local-mysql
Summary: installed mysql-server on localhost for Moodle
Group: Networking/WWW
Requires: %name-base < 2.0
Requires: /usr/sbin/mysqld
Requires: php5-mysql
Conflicts: %moodle_name >= 2.0
Conflicts: %moodle_name-base >= 2.0

%description local-mysql
%summary

#%package local-pgsql
#Summary: installed postgresql-server on localhost for Moodle
#Group: Networking/WWW
#Requires: %name = %version-%release
#Requires: postgresql8.2-server php5-pgsql

#%description local-pgsql
#%summary

%define auth_pam_moodlerequires %(echo %packagemoodleversion | sed -r 's/(^[0-9]+)(\..*)?/\1/')
%define auth_pam_packagemoodleversion %packagemoodleversion
%define auth_pam_packagemoodlerelease %packagversion
%package auth-pam
Version: %auth_pam_packagemoodlerelease.%auth_pam_packagemoodleversion.0.%packagedate
Summary: PAM authentication for Moodle
Group: Networking/WWW

Requires: pecl-pam
Requires: %moodle_name-base < 2.0
Requires: %moodle_authdir
Requires: %moodle_name-version >= %auth_pam_moodlerequires
Provides: %moodle_name-appfor = 1.9
Provides: %moodle_name-auth-pam-version = %auth_pam_packagemoodleversion
Provides: %moodle_name-auth-pam-appfor = %auth_pam_moodlerequires
Conflicts: %moodle_name >= 2.0
Conflicts: %moodle_name-base >= 2.0

%description auth-pam
PAM (Pluggable Authentication Modules) authentication methods for Moodle

%define mod_journal_moodlerequires 2007101509
%define mod_journal_packagemoodleversion 2007101509
%package mod-journal
Summary: Module Journal for Moodle
Group: Networking/WWW

Requires: %moodle_name-base < 2.0
Requires: %moodle_moddir
Requires: %moodle_name-version >= %mod_journal_moodlerequires
Provides: %moodle_name-appfor = 1.9
Provides: %moodle_name-mod-journal-version = %mod_journal_packagemoodleversion
Provides: %moodle_name-mod-journal-appfor = %mod_journal_moodlerequires
Conflicts: %moodle_name >= 2.0
Conflicts: %moodle_name-base >= 2.0

%description mod-journal
This module allows a teacher to ask students to reflect on a particular
topic. The students can edit and refine their answer over time.

%define mod_hotpot_moodlerequires 2007101509
%define mod_hotpot_packagemoodleversion 2007101513
%define mod_hotpot_packagemoodlerelease 2.4.13
%package mod-hotpot
Version: %mod_hotpot_packagemoodlerelease.%mod_hotpot_packagemoodleversion.0.%packagedate
Summary: HotPot module for Moodle
Group: Networking/WWW

Requires: %moodle_name-base < 2.0
Requires: %moodle_moddir
Requires: %moodle_questionformatdir
Requires: %moodle_name-version >= %mod_hotpot_moodlerequires
Provides: %moodle_name-appfor = 1.9
Provides: %moodle_name-mod-hotpot-version = %mod_hotpot_packagemoodleversion
Provides: %moodle_name-mod-hotpot-appfor = %mod_hotpot_moodlerequires
Conflicts: %moodle_name >= 2.0
Conflicts: %moodle_name-base >= 2.0

%description mod-hotpot
The Hotpot activity module allows teachers to administer Hot Potatoes
and TexToys quizzes via Moodle. These quizzes are created on
the teacher's computer and then uploaded to the Moodle course. After
students have attempted the quizzes, a number of reports are available
which show how individual questions were answered and some statistical
trends in the scores.

%add_perl_lib_path %moodle_filterdir/algebra
%define filter_from_reqprov /^perl(\\(AlgParser\\.pm\\|algebra2tex\\.pl\\))/d
%filter_from_provides %filter_from_reqprov
%filter_from_requires %filter_from_reqprov

%prep
%setup -q
%patch1 -p1
%patch2 -p1

rm -f filter/tex/*mimetex*
#rm -f filter/algebra/*
rm -f lib/default.ttf

%build

%install
# install moodle
mkdir -p %buildroot%moodle_dir/
mkdir -p %buildroot%moodle_datadir/
cp -rp * %buildroot%moodle_dir/

# create config.php
touch %buildroot%moodle_dir/config.php

%define mimetexlinux_filter %moodle_filterdir/tex/mimetex.linux
ln -s -f $(relative %buildroot%webserver_cgibindir/mimetex.cgi \
	%buildroot%mimetexlinux_filter) \
	%buildroot%mimetexlinux_filter

%define default_ttf %moodle_libdir/default.ttf
ln -s -f $(relative %buildroot%_ttffontsdir/freefont/FreeSans.ttf \
	%buildroot%default_ttf) \
	%buildroot%default_ttf

# install apache config
install -pD -m0644 %SOURCE10 %buildroot%_sysconfdir/httpd/conf/addon-modules.d/%name.conf

# install apache2 config
install -pD -m0644 %SOURCE20 %buildroot%apache2_extra_available/%name.conf
install -pD -m0644 %SOURCE21 %buildroot%apache2_extra_start/100-%name.conf
install -pD -m0644 %SOURCE22 %buildroot%apache2_mods_start/100-%name.conf
install -pD -m0644 %SOURCE23 %buildroot%apache2_confdir_inc/Directory_%{moodle_name}_default.conf

mkdir -p %buildroot%apache2_extra_enabled/
touch %buildroot%apache2_extra_enabled/%name.conf

#Disclosure of the macros
find %buildroot%moodle_dir/install.php %buildroot%_sysconfdir -type f -print0 \
	| xargs -r0 sed -ri "
s@%%(\{name\}|name([[:space:]/'\"=]))@%name\2@g
s@%%(\{webserver_datadir\}|webserver_datadir([[:space:]/'\"=]))@%webserver_datadir\2@g
s@%%(\{moodle_name\}|moodle_name([[:space:]/'\"=]))@%moodle_name\2@g
s@%%(\{moodle_dir\}|moodle_dir([[:space:]/'\"=]))@%moodle_dir\2@g
s@%%(\{moodle_datadir\}|moodle_datadir([[:space:]/'\"=]))@%moodle_datadir\2@g
"

%triggerun base -- moodle <= 1.9.13.20110817-alt2.1, moodle-base <= 1.9.16.20120217-alt3, moodle-apache <= 1.9.10-alt2.cvs20101110, moodle-apache2 <= 1.9.10-alt2.cvs20101110
if ls -l %moodle_dir/ | egrep -qsm1 '^([^[:space:]]+[[:space:]]+){3}(apache2?|root)[[:space:]]'; then
	echo "Warning: GUD directory %moodle_dir/ changed to %webserver_group."
	chgrp %webserver_group %moodle_dir/
fi
if [ -e "%moodle_dir/config.php" ]; then
	%_sbindir/web-condstop-rpm

	old_moodle_directorypermissions="`%_sbindir/mt-getCFG --file=%moodle_dir/config.php --format='%%05o' directorypermissions`"
	if [ "$old_moodle_directorypermissions" != "02770" ]; then
		new_moodle_directorypermissions="02770"
		echo "Warning: In the file %moodle_dir/config.php"
		echo "    \$CFG->directorypermissions value varies with the $old_moodle_directorypermissions on the $new_moodle_directorypermissions."
	else
		new_moodle_directorypermissions="$old_moodle_directorypermissions"
	fi

	old_moodle_dataroot="`%_sbindir/mt-getCFG --file=%moodle_dir/config.php dataroot`"
	if (echo "$old_moodle_dataroot" | \
			egrep -q '^[[:space:]]*(%moodle_olddatadir|%moodle_olddatadir2)(/+)?[[:space:]]*$'); then
		new_moodle_dataroot="%moodle_datadir"
		rpmold_moodle_dataroot="`echo "$old_moodle_dataroot" | \
			sed -r 's@^[[:space:]]([^[:space:]]+[^/[:space:]])/*[[:space:]]*$@\1.rpmold@'`"
		echo "Warning: In the file %moodle_dir/config.php"
		echo "    path $old_moodle_dataroot replaced by %moodle_datadir."
	else
		new_moodle_dataroot="$old_moodle_dataroot"
		rpmold_moodle_dataroot=
	fi

	if [ "$old_moodle_dataroot" != "$new_moodle_dataroot" ] \
			|| [ "$old_moodle_directorypermissions" != "$new_moodle_directorypermissions" ]; then
		echo 'Original file %moodle_dir/config.php is saved as %moodle_dir/config.php.rpmold.'
		cp -fa --backup=t "%moodle_dir/config.php" "%moodle_dir/config.php.rpmold"

		if [ "$old_moodle_dataroot" != "$new_moodle_dataroot" ] \
				&& [ -e "$old_moodle_dataroot" ] \
				&& [ -d "$old_moodle_dataroot" ] \
				&& ( \
					( \
						[ -e "$new_moodle_dataroot" ] \
						&& [ -d "$new_moodle_dataroot" ] \
						&& [ "x`find "$new_moodle_dataroot" -mindepth 1 -maxdepth 1`" = "x" ] \
					) \
					|| ( \
						[ ! -e "$new_moodle_dataroot" ] \
					) \
				); then
			echo "Original directory $old_moodle_dataroot is renamed as $rpmold_moodle_dataroot."
			mv "$old_moodle_dataroot" "$rpmold_moodle_dataroot"

			echo "All contents of the directory $old_moodle_dataroot"
			echo "is copied to the $new_moodle_dataroot."
			%_sbindir/mt-newdatadir --file=%moodle_dir/config.php \
				-m 'rpm update to %name-base-%version-%release' \
				"$new_moodle_dataroot"
			pushd "$rpmold_moodle_dataroot"
				find . -mindepth 1 -maxdepth 1 -printf '%%f\0' \
					| xargs -r0 cp -af --target-directory="$new_moodle_dataroot/"
			popd

			chmod $new_moodle_directorypermissions "%moodle_domainsdir"
			chown root:%webserver_group "%moodle_domainsdir"
		fi

		if [ "$old_moodle_directorypermissions" != "$new_moodle_directorypermissions" ]; then
			%_sbindir/mt-setCFG --file=%moodle_dir/config.php --no-quote \
				-m 'rpm update to %name-base-%version-%release' \
				directorypermissions $new_moodle_directorypermissions
		fi
	fi

	if [ -e "$new_moodle_dataroot" ] \
			&& [ -d "$new_moodle_dataroot" ]; then
		if [ "x`find "$new_moodle_dataroot" -mindepth 1 -type d ! -perm $new_moodle_directorypermissions`" != "x" ]; then
			echo "Warning: Change permissions of subdirectories"
			echo "    $new_moodle_dataroot on the $new_moodle_directorypermissions."
			find "$new_moodle_dataroot" -mindepth 1 -type d ! -perm $new_moodle_directorypermissions -print0 \
				| xargs -0 chmod $new_moodle_directorypermissions
		fi

		if [ "x`find "$new_moodle_dataroot" -mindepth 1 ! -group %webserver_group`" != "x" ]; then
			echo "Warning: GUD files and subdirectories"
			echo "    $old_moodle_dataroot changed to %webserver_group."
			find "$new_moodle_dataroot" -mindepth 1 ! -group %webserver_group -print0 \
				| xargs -0 chgrp %webserver_group
		fi
	fi

	%_sbindir/web-condstart-rpm
fi
exit 0

%triggerun apache2 -- moodle-apache2 <= 1.9.10-alt2.cvs20101110
if [ -e %apache2_addonconfdir/A.%name.conf ]; then
	echo "Warning: The configuration file %apache2_addonconfdir/A.%name.conf"
	echo "   outdated and was saved as %apache2_addonconfdir/N.%name.conf.rpmold."
	echo "   Use %apache2_extra_available/%name.conf."
	mv %apache2_addonconfdir/A.%name.conf %apache2_addonconfdir/N.%name.conf.rpmold
fi
exit 0

#%post apache
#chown root:apache %moodle_dir/
#control apache-mod_php5 relaxed
#%_initdir/httpd reload

#%postun apache
#%_initdir/httpd reload

%files

%files base
%dir %attr(2775,root,%webserver_group) %moodle_dir/
%ghost %config(noreplace) %moodle_dir/config.php
%moodle_dir/*
%exclude %moodle_authdir/pam/
%exclude %moodle_moddir/journal/
%exclude %moodle_moddir/hotpot/
%exclude %moodle_questionformatdir/hotpot/
%dir %attr(2770,root,%webserver_group) %moodle_datadir/

#%files apache
#%config(noreplace) %_sysconfdir/httpd/conf/addon-modules.d/%name.conf

%files apache2
%config(noreplace) %apache2_extra_available/%name.conf
%ghost %apache2_extra_enabled/%name.conf
%config(noreplace) %apache2_confdir_inc/Directory_%{moodle_name}_default.conf
%config(noreplace) %apache2_extra_start/100-%name.conf
%config(noreplace) %apache2_mods_start/100-%name.conf

%files local-mysql

#%files local-pgsql

%files auth-pam
%moodle_authdir/pam/

%files mod-journal
%moodle_moddir/journal/

%files mod-hotpot
%moodle_moddir/hotpot/
%moodle_questionformatdir/hotpot/

%changelog
