# This spec is backported to ALTLinux p8 automatically by rpmbph script from etersoft-build-utils.
#
%define mosquitto_user      mosquitto
%define mosquitto_group     mosquitto
%define lname     libmosquitto

Name: mosquitto
Version: 1.4.14
Release: alt0.M80P.1

Summary: Mosquitto is an open source implementation of a server for version 3.1 and 3.1.1 of the MQTT protocol

License: This project is dual licensed under the Eclipse Public License 1.0 and the Eclipse Distribution License 1.0 as described in the epl-v10 and edl-v10 files
Group: Development/C++
Url: http://mosquitto.org

Packager: Pavel Vainerman <pv@altlinux.ru>

# Source-url: http://mosquitto.org/files/source/%name-%version.tar.gz
Source: %name-%version.tar
Source1: %name
Source2: %name.sysconf
Source3: %name.conf

# Automatically added by buildreq on Mon Feb 01 2016
# optimized out: libcom_err-devel libkrb5-devel libstdc++-devel
BuildRequires: gcc-c++ libcares-devel libssl-devel libuuid-devel
Requires: %lname = %version-%release

%description
The Mosquitto project has been created to provide a light weight, open-source
implementation, of an MQTT broker to allow new, existing, and emerging
applications for Machine-to-Machine (M2M) and Internet of Things (IoT).

%package -n %lname
Group: Development/C
Summary: Libraries for mosquitto

%description -n %lname
Libraries for mosquitto

%package -n %lname-devel
Group: Development/C
Summary: Libraries needed to develop for mosquitto
Requires: %lname = %version-%release
Obsoletes: %name-devel

%description -n %lname-devel
Libraries needed to develop for mosquitto

%prep
%setup 

%build
subst 's|prefix=/usr/local|prefix=/usr|g' config.mk
%make_build

%install
%makeinstall_std
%ifarch x86_64
mkdir -p %buildroot%_libdir
mv -f %buildroot/usr/lib/* %buildroot%_libdir/
%endif

chmod a-x %buildroot%_includedir/*.h

mkdir -p %buildroot/%_initdir
cp %SOURCE1 %buildroot%_initdir/

mkdir -p %buildroot/%_sysconfdir/sysconfig
cp %SOURCE2 %buildroot%_sysconfdir/sysconfig/%name

mkdir -p %buildroot/%_sysconfdir/%name
cp %SOURCE3 %buildroot%_sysconfdir/%name

%pre
%_sbindir/groupadd -r -f %mosquitto_group 2>/dev/null ||:
%_sbindir/useradd -M -r -g %mosquitto_group -c 'Mosquitto daemon' -s /dev/null -d /dev/null %mosquitto_user 2>/dev/null ||:

%post
%post_service %name

%preun
%preun_service %name
        
%files
%dir %_sysconfdir/%name
%config %dir %_sysconfdir/%name/*
%config %_sysconfdir/sysconfig/%name
%_bindir/*
%_sbindir/*
%_man1dir/*
%_man3dir/*
%_man5dir/*
%_man7dir/*
%_man8dir/*
%_initdir/*

%files -n %lname
%_libdir/*.so.*

%files -n %lname-devel
%_includedir/*.h
%_libdir/*.so

%changelog
